<?php

namespace App\Enums;

enum DeliveryStatus: string
{
    case BOOKING = 'booking';
    case ARRIVEDWAREHOUSEPP = 'arrived_pp';
    case ARRIVEDWAREHOUSE = 'arrived_cn';
    case SORTING = 'sorting';
    case IN_STOCK = 'in_stock';
    case ASSIGNED = 'assigned';
    case DELIVERED = 'delivered';
    case COMPLETED = 'completed';
    case CANCELED = 'canceled';
    case RETURNED = 'returned';

    public function label(): string
    {
        return match ($this) {
            self::BOOKING => __('delivery_status.booking'),
            self::ARRIVEDWAREHOUSEPP => __('delivery_status.arrived_pp'),
            self::ARRIVEDWAREHOUSE => __('delivery_status.arrived_china'),
            self::SORTING => __('delivery_status.sorting'),
            self::IN_STOCK => __('delivery_status.in_stock'),
            self::ASSIGNED => __('delivery_status.assigned'),
            self::DELIVERED => __('delivery_status.delivered'),
            self::COMPLETED => __('delivery_status.completed'),
            self::CANCELED => __('delivery_status.canceled'),
            self::RETURNED => __('delivery_status.returned'),
        };
    }
}
