<?php

namespace App\Enums;

enum ShippingMethod: string
{
    case LAND = 'land';
    case AIR = 'air';
    case SEA = 'sea';

    public function label(): string
    {
        return match ($this) {
            self::LAND => __('booking.land'),
            self::AIR => __('booking.air'),
            self::SEA => __('booking.sea'),
        };
    }
}
