<?php

namespace App\Enums;

enum Status: string
{
    case ACTIVE = 'active';
    case INACTIVE = 'inactive';
    case PENDING = 'pending';
    case APPROVED = 'approved';
    case REJECTED = 'rejected';
    case PAID = 'paid';

    public function label(): string
    {
        return match ($this) {
            self::ACTIVE => __('status.active'),
            self::INACTIVE => __('status.inactive'),
            self::PENDING => __('status.pending'),
            self::APPROVED => __('status.approved'),
            self::REJECTED => __('status.rejected'),
            self::PAID => __('status.paid'),
        };
    }
}
