<?php

namespace App\Http\Controllers\Api;

use App\Enums\DeliveryStatus;
use App\Enums\PaymentMethod;
use App\Enums\PaymentTo;
use App\Enums\Status;
use App\Http\Controllers\Controller;
use App\Models\CancelReason;
use App\Traits\ApiResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Dedoc\Scramble\Attributes\QueryParameter;

class DeliveryStatusController extends Controller
{
    use ApiResponse;

   
    #[QueryParameter(
        name: 'lang',
        description: 'Language code (en, km)',
        required: false,
        example: 'km'
    )]

    public function index(Request $request)
    {
        $statuses = collect(DeliveryStatus::cases())->map(function ($status) {
            return [
                'value' => $status->value,
                'label' => $status->label(),
                'color' => match ($status) {
                    DeliveryStatus::IN_STOCK => 'text-navy-100',
                    DeliveryStatus::BOOKING => 'text-primary',
                    DeliveryStatus::ASSIGNED => 'text-info',
                    DeliveryStatus::DELIVERED, DeliveryStatus::COMPLETED => 'text-success',
                    DeliveryStatus::RETURNED => 'text-warning',
                    DeliveryStatus::CANCELED => 'text-error',
                    default => 'text-error',
                },
            ];
        });

        return $this->successResponse($statuses, 'Delivery Status');
    }

    #[QueryParameter(
        name: 'lang',
        description: 'Language code (en, km)',
        required: false,
        example: 'km'
    )]

    public function paymentTo()
    {
        $payment = collect(PaymentTo::cases())->map(function ($status) {
            return [
                'value' => $status->value,
                'label' => $status->label(),
            ];
        });

        return $this->successResponse($payment, 'Payment to list');
    }

    #[QueryParameter(
        name: 'lang',
        description: 'Language code (en, km)',
        required: false,
        example: 'km'
    )]

    public function paymentMethod()
    {
        $payment = collect(PaymentMethod::cases())->map(function ($status) {
            return [
                'value' => $status->value,
                'label' => $status->label(),
            ];
        });

        return $this->successResponse($payment, 'Payment methods list');
    }

    #[QueryParameter(
        name: 'lang',
        description: 'Language code (en, km)',
        required: false,
        example: 'km'
    )]

    public function cancelReason(Request $request){
        $branchId = $request->user()->default_branch_id;
        $data = CancelReason::where('status', Status::ACTIVE->value)
        ->where('branch_id',$branchId)
        ->select('id','reason')
        ->get();
        return $this->successResponse($data, 'cancel reason listing');
    }
}
