<?php

namespace App\Http\Controllers\Api;

use App\Enums\Status;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use App\Traits\ApiResponse;
class UserDeleteAccountController extends Controller
{
     use ApiResponse;
     /**
     * Deactivate user account.
     */

    public function deactivateUser(Request $request, User $user)
    {
        $auth = auth()->user();

        // Prevent self-deactivate
        if ($auth->id === $user->id) {
            abort(403, 'You cannot deactivate yourself.');
        }

        $user->update(['status' => Status::INACTIVE->value]);

        return $this->successResponse($user, 'User deactivated.');
    }


    /**
     * Deactivate the authenticated user's account.
     */
    public function deactivateSelf(Request $request)
    {
        $user = $request->user(); // authenticated user

        if ($user->status === Status::INACTIVE->value) {
            return response()->json([
                'success' => false,
                'message' => 'Your account is already deactivated.'
            ], 422);
        }

        // Set status to inactive
        $user->update(['status' => Status::INACTIVE->value]);

        // Revoke all tokens so the user is logged out
        $user->tokens()->delete();
        return $this->successResponse($user, 'Your account has been deactivated.');
    }

}
