<?php

namespace App\Http\Controllers;

use App\Enums\Status;
use App\Http\Requests\ExchangeRate\CreateRequest;
use App\Http\Requests\ExchangeRate\UpdateRequest;
use App\Models\ExchangeRate;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class ExchangeRateController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = ExchangeRate::where('branch_id', auth()->user()->default_branch_id)
                ->orderBy('created_at', 'desc');

            return DataTables::of($data)
                ->addColumn('branch', function ($row) {
                    return $row->branch->name ?? '-';
                })
                ->addColumn('action', function ($row) {
                    return view('pages.configuration.global-exchange-rate.action-dropdown', compact('row'))->render();
                })
                ->make(true);
        }

        return view('pages.configuration.global-exchange-rate.index');

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $data = $request->validated();
        $branchId = auth()->user()->default_branch_id;
        $data['branch_id'] = $branchId;
        ExchangeRate::where('branch_id', $branchId)
            ->update(['status' => Status::INACTIVE]);

        $data['status'] = Status::ACTIVE;
        $data['branch_id'] = $branchId;

        ExchangeRate::create($data);

        return response()->json(['success' => true, 'message' => 'Exchange rate saved successfully.']);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, string $id)
    {
        $data = $request->validated();
        $exchangeRate = ExchangeRate::findOrFail($id);
        $exchangeRate->update($data);

        return response()->json(['success' => true, 'message' => 'Exchange rate updated successfully.']);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
