<?php

namespace App\Http\Controllers;

use App\Imports\DeliveryImport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;

class ImportDeliveryController extends Controller
{
    public function index()
    {
        return view('pages.delivery.import.index');
    }

    public function import(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'file' => 'required|mimes:xlsx,xls,csv|max:2048',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'message' => $validator->errors()->first('file'),
            ], 422);
        }

        Excel::import(new DeliveryImport(
            pickupBy: auth()->id(),
        ), $request->file('file'));

        return response()->json([
            'success' => true,
            'message' => 'Import successfully.',
        ]);

    }
}
