<?php

namespace App\Http\Controllers;

use App\Models\Delivery;
use Illuminate\Http\Request;
use App\Enums\DeliveryStatus;

class TrackingController extends Controller
{
    public function tracking(Request $request)
    {
        $code = $request->input('code');

        $delivery = Delivery::with(['statuses', 'statuses.changedBy'])
            ->where('code', $code)
            ->orWhere('tracking_number', $code)
            ->orWhere('local_tracking', $code)
            ->first();

        if (! $delivery) {
            return response()->json(['message' => 'Tracking code not found.'], 404);
        }

        // $statuses = $delivery->statuses->map(function ($status) {
        //     return [
        //         'id' => $status->id,
        //         'status' => $status->status,
        //         'changed_by' => $status->changedBy->name ?? 'System',
        //         'diff_for_humans' => $status->created_at->diffForHumans(),
        //         'changed_at' => $status->changed_at,
        //         'note' => $status->note,
        //     ];
        // });
        $statuses = $delivery->statuses->map(function ($status) {
            return [
                'id' => $status->id,
        
                // 1. Try to create the Enum from the database value
                // 2. Call label()
                // 3. Fallback to the raw value if something goes wrong
                'status' => DeliveryStatus::tryFrom($status->status)?->label() ?? $status->status,
                
                'changed_by' => $status->changedBy->name ?? 'System',
                'diff_for_humans' => $status->created_at->diffForHumans(),
                'changed_at' => $status->changed_at,
                'note' => $status->note,
            ];
        });

        return response()->json(['statuses' => $statuses]);
    }
}
