<?php

namespace App\Http\Controllers;

use App\Http\Requests\ZoneType\CreateRequest;
use App\Http\Requests\ZoneType\UpdateRequest;
use App\Models\ZoneType;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class ZoneTypesController extends Controller
{
    /**
     * @method void middleware($middleware, array|string $options = [])
     */
    public function __construct()
    {
        $this->middleware('permission:zone-types.view')->only(['index', 'show']);
        $this->middleware('permission:zone-types.create')->only(['create', 'store']);
        $this->middleware('permission:zone-types.edit')->only(['edit', 'update']);
        $this->middleware('permission:zone-types.delete')->only(['destroy']);
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = ZoneType::with('branch')
                ->where('branch_id', auth()->user()->default_branch_id)
                ->orderBy('created_at', 'desc');

            return DataTables::of($data)
                ->addColumn('branch', function ($row) {
                    return $row->branch->name ?? '-';
                })
                ->addColumn('action', function ($row) {
                    return view('pages.configuration.zone-types.action-dropdown', compact('row'))->render();
                })
                ->make(true);
        }

        return view('pages.configuration.zone-types.index');

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pages.configuration.zone-types.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $validated = $request->validated();
        ZoneType::create([
            'branch_id' => auth()->user()->default_branch_id,
            'zone_type' => $validated['zone_type'],
            'price' => $validated['price'],
            'express' => $validated['express'],
            'status' => $validated['status'],
        ]);

        return back()->with('success', 'Zone types created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ZoneType $zoneType)
    {
        return view('pages.configuration.zone-types.edit', compact('zoneType'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, ZoneType $zoneType)
    {
        $validated = $request->validated();

        $zoneType->update([
            'zone_type' => $validated['zone_type'],
            'price' => $validated['price'],
            'express' => $validated['express'],
            'status' => $validated['status'],
        ]);

        return back()->with('success', 'Zone Types updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
