<?php

namespace App\Http\Requests\Booking;

use Illuminate\Foundation\Http\FormRequest;

class ShipmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'truck_by' => ['required', 'exists:users,id'],

            'delivery_ids' => ['required', 'array', 'min:1'],
            'delivery_ids.*' => ['required', 'exists:delivery,id'],

            'rows' => ['required', 'array'],
            'rows.*.kg' => ['required', 'numeric', 'min:0'],
            'rows.*.cbm' => ['required', 'numeric', 'min:0'],
            'rows.*.pcs' => ['required', 'integer', 'min:0'],
            'rows.*.amount_usd' => ['required', 'numeric', 'min:0'],
        ];
    }

    // public function withValidator($validator)
    // {
    //     $validator->after(function ($validator) {
    //         $count = count($this->delivery_ids ?? []);

    //         foreach (['kg', 'cbm', 'pcs', 'amount_usd'] as $field) {
    //             if (count($this->$field ?? []) !== $count) {
    //                 $validator->errors()->add(
    //                     $field,
    //                     'Row count mismatch. Please reselect deliveries.'
    //                 );
    //             }
    //         }
    //     });
    // }

}
