<?php

namespace App\Http\Requests\Delivery;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\User;

class ChangeDriverRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'new_delivery_by' => [
                'required',
                'integer',
                function ($attribute, $value, $fail) {
                    $value = (int) $value; // CAST to int

                    // allow 0 or existing user ID
                    if ($value !== 0 && ! User::where('id', $value)->exists()) {
                        $fail("The selected {$attribute} is invalid.");
                    }
                },
            ],
            'delivery_ids' => 'required|array|min:1',
            'delivery_ids.*' => 'exists:delivery,id',
        ];
    }
}
