<?php

namespace App\Http\Requests\DriverPayment;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'delivery_by' => 'required|exists:users,id',
            'delivery_ids' => 'required|array',
            'delivery_ids.*' => 'exists:delivery,id',
            'payments' => 'required|array|min:1',
            'payments.*.amount' => 'required|numeric|min:0',
            'payments.*.currency' => 'required|in:usd,khr',
            'payments.*.payment_method' => 'required|in:cash,transfer',
            'driver_collect_usd' => 'required',
            'driver_collect_khr' => 'required',
        ];
    }
}
