<?php

namespace App\Http\Requests\ExchangeRate;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'currency_from' => 'required|string|max:10',
            'currency_to' => 'required|string|max:10',
            'rate' => 'required|numeric|min:0',
            'id' => 'nullable|integer|exists:exchange_rate,id', // For update
        ];
    }
}
