<?php

namespace App\Http\Requests\Users;

use Illuminate\Foundation\Http\FormRequest;

class UpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'display_name' => 'required|string|max:255',
            'name' => 'required|string|max:255|unique:users,name,'.$this->user->id,
            'email' => 'nullable|email|unique:users,email,'.$this->user->id,
            'phone' => 'required|string|max:20|unique:users,phone,'.$this->user->id,
            'gender' => 'required|in:male,female',
            'status' => 'required|in:active,inactive',
            'role' => 'required|exists:roles,name',
            'branches' => 'required|array',
            'branches.*' => 'exists:branches,id',
        ];
    }
}
