<?php

namespace App\Main;

class SidebarPanel
{
    public static function dashboards()
    {
        return [
            'title' => __('side_bar_menu.dashboard_management'),
            'items' => [
                [
                    'dashboard' => [
                        'title' => '1 - Dashboard',
                        'route_name' => 'dashboards',
                        'permission' => 'dashboards.view',
                    ],
                    // 'driver_dashboard' => [
                    //     'title' => '2 - Driver Summary',
                    //     'route_name' => 'driver-summary-dashboard',
                    //     'permission' => 'driver-summary-dashboard.view',
                    // ],
                    // 'customer_dashboard' => [
                    //     'title' => '3 - Customer Summary',
                    //     'route_name' => 'customer-summary-dashboard',
                    //     'permission' => 'customer-summary-dashboard.view',
                    // ],
                ],

            ],
        ];
    }

    public static function customer()
    {
        return [
            'title' => __('side_bar_menu.customer'),
            'items' => [
                [
                    'list_all_customer' => [
                        'title' => __('side_bar_menu.list_all_customer'),
                        'route_name' => 'customer',
                        'permission' => 'customers.view',
                    ],
                    'book_pickup' => [
                        'title' => __(('side_bar_menu.book_pickup')),
                        'route_name' => 'book-pickup',
                        'permission' => 'customers.view',
                    ],
                ],

            ],
        ];
    }

    public static function booking()
    {
        return [
            'title' => __('side_bar_menu.manage_booking'),
            'items' => [
                [
                    'list_all_booking' => [
                        'title' => __('side_bar_menu.list_all_booking'),
                        'route_name' => 'booking',
                        'permission' => 'booking.view',
                    ],
                    'create_booking_order' => [
                        'title' => __('side_bar_menu.add_new_booking'),
                        'route_name' => 'booking-order',
                        'permission' => 'booking.create',
                    ],
                    'transit_list' => [
                        'title' => __('side_bar_menu.transit'),
                        'route_name' => 'transit',
                        'permission' => 'booking.create',
                    ],
                    'in_transit_list' => [
                        'title' => __('side_bar_menu.list_all_transit'),
                        'route_name' => 'in-transit',
                        'permission' => 'booking.create',
                    ],
                    'shipment' => [
                        'title' => __('side_bar_menu.shipment'),
                        'route_name' => 'shipment',
                        'permission' => 'booking.create',
                    ],
                ],

            ],
        ];
    }

    public static function delivery()
    {
        return [
            'title' => __('side_bar_menu.manage_deliveries'),
            'items' => [
                [

                    'create_delivery_group' => [
                        'title' => __('side_bar_menu.add_new_delivery'),
                        'route_name' => 'data-inquiry',
                        'permission' => 'delivery.create',
                    ],
                    'list_all_delivery' => [
                        'title' => __('side_bar_menu.list_all_delivery'),
                        'route_name' => 'delivery',
                        'permission' => 'delivery.view',
                    ],
                    'assign_delivery' => [
                        'title' => __('side_bar_menu.assign_drivers'),
                        'route_name' => 'assign-driver',
                        'permission' => 'delivery.assign',
                    ],
                    'scan_assign' => [
                        'title' => __('side_bar_menu.scan_assign'),
                        'route_name' => 'scan-assign',
                        'permission' => 'delivery.assign',
                    ],
                    'transfer_delivery' => [
                        'title' => __('side_bar_menu.transfer_deliveries'),
                        'route_name' => 'change-driver',
                        'permission' => 'delivery.transfer',
                    ],
                    'remove_delivery' => [
                        'title' => __('side_bar_menu.remove_deliveries'),
                        'route_name' => 'remove-delivery',
                        'permission' => 'delivery.remove',
                    ],
                     'return_delivery' => [
                        'title' => __('side_bar_menu.return_deliveries'),
                        'route_name' => 'return-delivery',
                        'permission' => 'delivery.remove',
                    ],

                ],

            ],
        ];
    }

    public static function driverPayment()
    {
        return [
            'title' => __('side_bar_menu.driver_payment'),
            'items' => [
                [
                    'collect_payment_with_driver' => [
                        'title' => __('side_bar_menu.collect_driver'),
                        'route_name' => 'driver-collect-payment',
                        'permission' => 'driver-payment.view',
                    ],
                    'summary_driver_payment' => [
                        'title' => __('side_bar_menu.driver_payment_sum'),
                        'route_name' => 'driver-payment',
                        'permission' => 'driver-payment.view',
                    ],
                ],

            ],
        ];
    }

    public static function customerPayment()
    {
        return [
            'title' => __('side_bar_menu.customer_payment'),
            'items' => [
                [
                    'all_shop' => [
                        'title' => __('side_bar_menu.all_shop'),
                        'route_name' => 'all-shop-collect-payment',
                        'permission' => 'customer-payment.view',
                    ],
                    'collect_payment_with_shop' => [
                        'title' => __('side_bar_menu.collect_payment'),
                        'route_name' => 'shop-collect-payment',
                        'permission' => 'customer-payment.view',
                    ],
                    'summary_shop_payment' => [
                        'title' => __('side_bar_menu.payment_sum'),
                        'route_name' => 'shop-summary-payment',
                        'permission' => 'customer-payment.view',
                    ],
                    'income_from_delivery' => [
                        'title' => __('side_bar_menu.EOD_sum'),
                        'route_name' => 'summaryIncomeFromDelivery',
                        'permission' => 'customer-payment.view',
                    ],

                ],

            ],
        ];
    }

    public static function reports()
    {
        return [
            'title' => __('side_bar_menu.reports'),
            'items' => [
                [
                    'list_all_report' => [
                        'title' => __('side_bar_menu.list_all_report'),
                        'route_name' => 'reports',
                        'permission' => 'reports.view1',
                    ],
                    'driver_earning' => [
                        'title' => __('side_bar_menu.driver_earning'),
                        'route_name' => 'driverEarning',
                        'permission' => 'reports.view1',
                    ],
                    'driver_pickup_commission' => [
                        'title' => __('side_bar_menu.driver_pickup_com'),
                        'route_name' => 'pickUpCommission',
                        'permission' => 'reports.view1',
                    ],
                    'income_from_shop' => [
                        'title' => __('side_bar_menu.income_from_cus'),
                        'route_name' => 'incomeShop',
                        'permission' => 'reports.view1',
                    ],

                ],

            ],
        ];
    }

    public static function configuration()
    {
        return [
            'title' => __('side_bar_menu.configuration'),
            'items' => [
                [
                    'branch' => [
                        'title' => __('side_bar_menu.branch'),
                        'route_name' => 'branch',
                        'permission' => 'branch.view',
                    ],
                    'warehouse' => [
                        'title' => __('side_bar_menu.warehouse'),
                        'route_name' => 'warehouse',
                        'permission' => 'branch.view',
                    ],
                    'roles_permission' => [
                        'title' => __('side_bar_menu.role_permission'),
                        'route_name' => 'roles',
                        'permission' => 'roles.view',
                    ],
                    'users' => [
                        'title' => __('side_bar_menu.manage_staff'),
                        'route_name' => 'users',
                        'permission' => 'users.view',
                    ],
                    'cancel' => [
                        'title' => __('side_bar_menu.cancel_reasons'),
                        'route_name' => 'cancel-reason',
                        'permission' => 'cancel-reason.view',
                    ],
                    'zone_type' => [
                        'title' => __('side_bar_menu.zone_type'),
                        'route_name' => 'zone-types',
                        'permission' => 'zone-types.view',
                    ],
                    'zone' => [
                        'title' => __('side_bar_menu.zone_price'),
                        'route_name' => 'zone-price',
                        'permission' => 'zone-price.view',
                    ],
                    'assign_zone' => [
                        'title' => __('side_bar_menu.assign_zone'),
                        'route_name' => 'assign-zones',
                        'permission' => 'assign-zones.view',
                    ],
                    'global_exchange_rate' => [
                        'title' => __('side_bar_menu.global_exchange'),
                        'route_name' => 'global-exchange-rate',
                        'permission' => 'global-exchange-rate.view',
                    ],
                ],
            ],
        ];
    }

    public static function setting()
    {
        return [
            'title' => __('side_bar_menu.manage_setting'),
            'items' => [
                [
                    'setting' => [
                        'title' => __('side_bar_menu.setting'),
                        'route_name' => 'setting',
                        'permission' => 'setting.view',
                    ],
                ],
            ],
        ];
    }

    public static function all()
    {
        return [self::dashboards(), self::booking(),  self::delivery(), self::customer(), self::driverPayment(),
            self::customerPayment(), self::reports(), self::setting(), self::configuration()];
    }
}
