<?php

namespace App\Models;

class ShopCollectDeliveryPayment extends BaseLoggableModel
{
    protected $table = 'shop_collect_delivery_payment';

    protected $fillable = [
        'customer_id',
        'summary_shop_payment_id',
        'delivery_id',
        'payment_to',
        'amount',
        'currency',
        'payment_method',
        'payment_date',
        'status', // 'collected', 'reverted'
        'note',
        'created_by',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function delivery()
    {
        return $this->belongsTo(Delivery::class, 'delivery_id');
    }

    public function summary()
    {
        return $this->belongsTo(SummaryShopPayment::class, 'summary_shop_payment_id');
    }
}
