<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('confirm_shop_payment', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\SummaryShopPayment::class, 'summary_shop_payment_id')
                ->constrained('summary_shop_payment')
                ->onDelete('cascade');
            $table->foreignIdFor(\App\Models\Customer::class, 'customer_id')
                ->constrained('customers')
                ->onDelete('cascade');
            $table->decimal('amount', 10, 2)->default(0);
            $table->string('currency', 3)->default('usd');
            $table->string('payment_method')->nullable(); // cash, bank, transfer, etc.
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('confirm_shop_payment');
    }
};
