<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('shop_collect_delivery_payment', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(\App\Models\SummaryShopPayment::class, 'summary_shop_payment_id')
                ->constrained('summary_shop_payment')
                ->onDelete('cascade');
            $table->unsignedBigInteger('customer_id');
            $table->unsignedBigInteger('delivery_id');
            $table->timestamp('payment_date')->nullable();
            $table->string('status', 50)->default('collected'); // 'collected', 'reverted'
            $table->text('note')->nullable();
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('cascade');
            $table->foreign('delivery_id')->references('id')->on('delivery')->onDelete('cascade');
            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('shop_collect_delivery_payment');
    }
};
