<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('book_pickup_images', function (Blueprint $table) {
            $table->id();
            $table->foreignId('book_pickup_id')->nullable()->constrained('book_pickup')->onDelete('set null');
            $table->string('image');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
       Schema::dropIfExists('book_pickup_images');
    }
};
