<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delivery_qr_codes', function (Blueprint $table) {
            $table->id();
            $table->string('qr_code')->unique(); // the actual QR content
            $table->foreignId('customer_id')->nullable()->constrained('customers')->onDelete('set null');
            $table->integer('qty')->default(0);
            $table->boolean('is_printed')->default(false); // QR printed status
            $table->timestamp('printed_at')->nullable();
            $table->boolean('is_assigned')->default(false); // assigned to a delivery
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
       Schema::dropIfExists('delivery_qr_codes');
    }
};
