<?php

namespace Database\Seeders;

use App\Models\Branch;
use Illuminate\Database\Seeder;

class BranchesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Example branches
        $branches = [
            [
                'name' => 'Main Branch',
                'short_name' => 'Main',
                'type' => 'Head Office',
                'status' => 'active',
                'code' => 'BR001',
                'logo' => 'default-logo.png',
                'address' => '123 Main Street, City',
                'phone' => '0123456789',
                'email' => 'main@company.com',
            ],
            [
                'name' => 'Secondary Branch',
                'short_name' => 'Second',
                'type' => 'Branch Office',
                'status' => 'active',
                'code' => 'BR002',
                'logo' => 'default-logo.png',
                'address' => '456 Second Street, City',
                'phone' => '0987654321',
                'email' => 'second@company.com',
            ],
            // Add more branches as needed
        ];

        foreach ($branches as $branch) {
            Branch::create($branch);
        }
    }
}
