<?php

namespace Database\Seeders;

use App\Models\Customer;
use Illuminate\Database\Seeder;

class CustomerTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $customers = [
            [
                'ref_code' => '0000001',
                'customer_name' => 'Camping Zone',
                'email' => null,
                'phone' => '012345678',
                'address' => '123 Main St, Phnom Penh',
                'status' => 'active', // Default status is active
                'mou_price' => 1.00, // MOU service price
                'currency' => 'USD',
                'first_delivery_date' => '2025-07-01', // First delivery date
                'last_delivery_date' => '2025-07-31', // Last delivery date
            ],
            [
                'ref_code' => '0000002',
                'customer_name' => 'EK Cambodia',
                'email' => null,
                'phone' => '098765432',
                'address' => '456 Elm St, Siem Reap',
                'status' => 'active', // Default status is active
                'mou_price' => 2.00, // MOU service price
                'currency' => 'USD',
                'first_delivery_date' => '2025-07-05', // First delivery date
                'last_delivery_date' => '2025-07-25', // Last delivery date
            ],
        ];
        foreach ($customers as $customer) {
            Customer::create([
                'ref_code' => $customer['ref_code'],
                'user_id' => 1, // Assuming user_id 1 exists
                'branch_id' => 1, // Assuming branch_id 1 exists
                'customer_name' => $customer['customer_name'],
                'email' => $customer['email'],
                'phone' => $customer['phone'],
                'address' => $customer['address'],
                'status' => $customer['status'],
                'mou_price' => $customer['mou_price'],
                'currency' => $customer['currency'],
                'first_delivery_date' => $customer['first_delivery_date'],
                'last_delivery_date' => $customer['last_delivery_date'],
            ]);
        }
    }
}
