<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class ZoneTypeTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Example zone types
        $zoneTypes = [
            [
                'branch_id' => 1,
                'zone_type' => 'Zone A',
                'status' => 'active',
                'price' => 1.00,
                'express' => 0.25,
            ],
            [
                'branch_id' => 1,
                'zone_type' => 'Zone B',
                'status' => 'active',
                'price' => 1.5,
                'express' => 0.35,
            ],
            [
                'branch_id' => 1,
                'zone_type' => 'Zone C',
                'status' => 'active',
                'price' => 2,
                'express' => 0.45,
            ],
            [
                'branch_id' => 1,
                'zone_type' => 'Zone D',
                'status' => 'active',
                'price' => 2.5,
                'express' => 0.5,
            ],
            // Add more zone types as needed
        ];

        foreach ($zoneTypes as $zoneType) {
            \App\Models\ZoneType::create($zoneType);
        }
    }
}
