<?php

namespace App\Enums;

enum BookingStatus: string
{
    case BOOKING = 'booking';
    case ARRIVEDWAREHOUSE = 'arrived_cn';
    case IN_TRANSIT = 'in_transit';
    case ARRIVEDWAREHOUSEPP = 'arrived_pp';

    public function label(): string
    {
        return match ($this) {
            self::BOOKING => 'Booking',
            self::ARRIVEDWAREHOUSE => 'Arrived CH China',
            self::IN_TRANSIT => 'In Transit',
            self::ARRIVEDWAREHOUSEPP => 'Arrived CH PP',
        };
    }
}
