<?php

namespace App\Enums;

enum DeliveryStatus: string
{
    case BOOKING = 'booking';
    case ARRIVEDWAREHOUSEPP = 'arrived_pp';
    case ARRIVEDWAREHOUSE = 'arrived_cn';
    case SORTING = 'sorting';
    case IN_STOCK = 'in_stock';
    case ASSIGNED = 'assigned';
    case DELIVERED = 'delivered';
    case COMPLETED = 'completed';
    case CANCELED = 'canceled';
    case RETURNED = 'returned';

    public function label(): string
    {
        return match ($this) {
            self::BOOKING => 'Booking',
            self::ARRIVEDWAREHOUSEPP => 'Arrived PP',
            self::ARRIVEDWAREHOUSE => 'Arrived China',
            self::SORTING => 'Sorting',
            self::IN_STOCK => 'In Stock',
            self::ASSIGNED => 'Assigned',
            self::DELIVERED => 'Delivered',
            self::COMPLETED => 'Completed',
            self::CANCELED => 'Canceled',
            self::RETURNED => 'Returned',
        };
    }
}
