<?php

namespace App\Enums;

enum ShippingMethod: string
{
    case LAND = 'land';
    case AIR = 'air';
    case SEA = 'sea';

    public function label(): string
    {
        return match ($this) {
            self::LAND => 'Land',
            self::AIR => 'Air',
            self::SEA => 'Sea',
        };
    }
}
