<?php

namespace App\Http\Controllers\Api;

use App\Enums\DeliveryStatus;
use App\Enums\PaymentMethod;
use App\Enums\PaymentTo;
use App\Http\Controllers\Controller;
use App\Traits\ApiResponse;

class DeliveryStatusController extends Controller
{
    use ApiResponse;

    public function index()
    {
        $statuses = collect(DeliveryStatus::cases())->map(function ($status) {
            return [
                'value' => $status->value,
                'label' => $status->label(),
                'color' => match ($status) {
                    DeliveryStatus::IN_STOCK => 'text-navy-100',
                    DeliveryStatus::BOOKING => 'text-primary',
                    DeliveryStatus::ASSIGNED => 'text-info',
                    DeliveryStatus::DELIVERED, DeliveryStatus::COMPLETED => 'text-success',
                    DeliveryStatus::RETURNED => 'text-warning',
                    DeliveryStatus::CANCELED => 'text-error',
                    default => 'text-error',
                },
            ];
        });

        return $this->successResponse($statuses, 'Delivery Status');
    }

    public function paymentTo()
    {
        $payment = collect(PaymentTo::cases())->map(function ($status) {
            return [
                'value' => $status->value,
                'label' => $status->label(),
            ];
        });

        return $this->successResponse($payment, 'Payment to list');
    }

    public function paymentMethod()
    {
        $payment = collect(PaymentMethod::cases())->map(function ($status) {
            return [
                'value' => $status->value,
                'label' => $status->label(),
            ];
        });

        return $this->successResponse($payment, 'Payment methods list');
    }
}
