<?php

namespace App\Http\Controllers;

use App\Http\Requests\CancelReason\CreateRequest;
use App\Http\Requests\CancelReason\UpdateRequest;
use App\Models\CancelReason;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class CancelReasonController extends Controller
{
    /**
     * @method void middleware($middleware, array|string $options = [])
     */
    public function __construct()
    {
        $this->middleware('permission:cancel-reason.view')->only(['index', 'show']);
        $this->middleware('permission:cancel-reason.create')->only(['create', 'store']);
        $this->middleware('permission:cancel-reason.edit')->only(['edit', 'update']);
        $this->middleware('permission:cancel-reason.delete')->only(['destroy']);
    }

    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $branchId = auth()->user()->default_branch_id;
            $data = CancelReason::where('branch_id', $branchId)
                ->orderBy('created_at', 'desc');

            return DataTables::of($data)
                ->addColumn('branch', function ($row) {
                    return $row->branch->name ?? '-';
                })
                ->addColumn('action', function ($row) {
                    return view('pages.configuration.cancel-reason.action-dropdown', compact('row'))->render();
                })
                ->make(true);
        }

        return view('pages.configuration.cancel-reason.index');

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('pages.configuration.cancel-reason.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $validated = $request->validated();
        CancelReason::create([
            'branch_id' => auth()->user()->default_branch_id,
            'reason' => $validated['reason'],
            'create_by' => auth()->id(),
            'status' => $validated['status'],
        ]);

        return back()->with('success', 'Cancel reason created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(CancelReason $cancelReason)
    {
        return view('pages.configuration.cancel-reason.edit', compact('cancelReason'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, CancelReason $cancelReason)
    {
        $validated = $request->validated();

        $cancelReason->update([
            'reason' => $validated['reason'],
            'update_by' => auth()->id(),
            'status' => $validated['status'],
        ]);

        return back()->with('success', 'Cancel reason updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
