<?php

namespace App\Http\Requests\Api\Delivery;

use App\Enums\DeliveryStatus;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Enum;

class DeliveryListRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'driver_id' => 'required|integer',
            'customer_id' => 'nullable|integer',
            'status' => ['nullable', new Enum(DeliveryStatus::class)],
            /*
           * Date: YYYY-MM-DD
           */
            'date' => ['nullable', 'string', function ($attribute, $value, $fail) {
                $dates = explode(' to ', $value);

                foreach ($dates as $date) {
                    if (! strtotime($date)) {
                        $fail('The '.$attribute.' contains an invalid date.');
                    }
                }

                if (count($dates) > 2) {
                    $fail('The '.$attribute.' format is invalid. Use YYYY-MM-DD or YYYY-MM-DD to YYYY-MM-DD.');
                }
            }],
        ];
    }
}
