<?php

namespace App\Http\Requests\Delivery;

use Illuminate\Foundation\Http\FormRequest;

class UpdatedRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'zone_price_id' => 'nullable|exists:zone_price,id',
            'receiver_address' => 'required|string',
            'delivery_price' => 'required|numeric',
            'receiver_phone' => [
                'required',
                'regex:/^(0(10|11|12|14|17|18|61|69|70|71|76|77|78|86|87|88|89|90|93|97|98|31|60))[0-9]{6}$/',
            ],
            'amount_usd' => 'required|numeric|min:0',
            'amount_khr' => 'required|numeric|min:0',
            'type_of_delivery' => 'required|string|in:Normal,Express',
            'type_of_cod' => 'required|string|in:Yes,No',
            'note' => 'nullable|string|max:255',
            'any_extra_fee' => 'nullable|numeric|min:0',
            'who_pay_fee' => 'required|string|in:Driver,Company,Shop',
        ];
    }

    public function messages()
    {
        return [
            'receiver_phone.regex' => 'The phone number format is invalid or not supported by Cambodian telecom operators.',
            'type_of_delivery.in' => 'The type of delivery must be either Normal or Express.',
            'type_of_cod.in' => 'The type of COD must be either Yes or No.',
        ];
    }

    public function attributes()
    {
        return [
            'zone_price_id' => 'Zone Price',
            'receiver_address' => 'Receiver Address',
            'delivery_price' => 'Delivery Price',
            'receiver_phone' => 'Receiver Phone',
            'amount_usd' => 'Amount in USD',
            'amount_khr' => 'Amount in KHR',
            'type_of_delivery' => 'Type of Delivery',
            'note' => 'Note',
        ];
    }
}
