<?php

namespace App\Http\View\Composers;

use App\Main\SidebarPanel;
use Illuminate\View\View;

class SidebarComposer
{
    /**
     * Bind data to the view.
     *
     * @return void
     */
    public function compose(View $view)
    {
        if (! is_null(request()->route())) {
            $pageName = request()->route()->getName();

            $routePrefix = explode('/', $pageName)[0] ?? '';

            switch ($routePrefix) {
                case 'delivery.index':
                case 'delivery.create':
                case 'delivery.edit':
                case 'delivery.show':
                case 'data-inquiry.index':
                case 'assign-driver.index':
                case 'remove-delivery.index':
                case 'change-driver.index':
                    $view->with('sidebarMenu', SidebarPanel::delivery());
                    break;

                case 'customer.index':
                case 'customer.create':
                case 'customer.edit':
                case 'customer.show':
                    $view->with('sidebarMenu', SidebarPanel::customer());
                    break;
                case 'booking.index':
                case 'booking-order.create':
                case 'booking-order.index':
                case 'transit.index':
                case 'in-transit.index':
                case 'shipment.index':
                    $view->with('sidebarMenu', SidebarPanel::booking());
                    break;
                case 'driver-payment.index':
                case 'driver-collect-payment.index':
                case 'driver-collect-payment.show':
                case 'driver-collect-payment.edit':
                    $view->with('sidebarMenu', SidebarPanel::driverPayment());
                    break;
                case 'shop-collect-payment.index':
                case 'shop-collect-payment.show':
                case 'shop-collect-payment.edit':
                case 'shop-summary-payment.index':
                case 'summaryIncomeFromDelivery.index':
                case 'all-shop-collect-payment.index':
                    $view->with('sidebarMenu', SidebarPanel::customerPayment());
                    break;
                case 'configuration.index':
                case 'branch.index':
                case 'branch.create':
                case 'branch.edit':
                case 'warehouse.index':
                case 'warehouse.create':
                case 'warehouse.edit':
                case 'cancel-reason.index':
                case 'cancel-reason.create':
                case 'cancel-reason.edit':
                case 'zone-price.index':
                case 'zone-price.create':
                case 'zone-price.edit':
                case 'zone-types.index':
                case 'zone-types.create':
                case 'zone-types.edit':
                case 'assign-zones.index':
                case 'assign-zones.create':
                case 'assign-zones.edit':
                case 'users.index':
                case 'users.create':
                case 'users.edit':
                case 'roles.index':
                case 'roles.create':
                case 'roles.edit':
                case 'global-exchange-rate.index':
                case 'global-exchange-rate.create':
                case 'global-exchange-rate.edit':

                    $view->with('sidebarMenu', SidebarPanel::configuration());
                    break;
                case 'reports.index':
                case 'driverEarning.index':
                case 'pickUpCommission.index':
                case 'incomeShop.index':
                    $view->with('sidebarMenu', SidebarPanel::reports());
                    break;
                case 'setting.index':
                    $view->with('sidebarMenu', SidebarPanel::setting());
                    break;

                default:
                    // Default to dashboards if no specific route matches
                case 'dashboards.index':
                case 'driver-summary-dashboard.index':
                case 'customer-summary-dashboard.index':
                    //   dd($routePrefix);
                    $view->with('sidebarMenu', SidebarPanel::dashboards());
            }

            // $view->with('allSidebarItems', SidebarPanel::all());
            $view->with('pageName', $pageName);
            $view->with('routePrefix', $routePrefix);
        }
    }
}
