<?php

namespace App\Models;

class Delivery extends BaseLoggableModel
{
    protected $table = 'delivery';

    protected $fillable = [
        'truck_id',
        'from_warehouse_id',
        'shipping_method',
        'tracking_number',
        'local_tracking',
        'photo',
        'kg',
        'pcs',
        'cbm',
        'to_warehouse_id',
        'code',
        'branch_id',
        'customer_id',
        'zone_price_id',
        'receiver_address',
        'receiver_phone',
        'pickup_at',
        'pickup_by',
        'assigned_at',
        'delivery_by',
        'delivery_price',
        'amount_usd',
        'amount_khr',
        'status',
        'type_of_delivery',
        'type_of_cod',
        'any_extra_fee',
        'who_pay_fee',
        'note',
        'completed_at',
        'is_collected',
        'collected_by',
        'canceled_at',
        'created_by',
        'updated_by',
        'deleted_by',
        'is_active',
        'is_deleted',
        'deleted_reason',
        'is_paid',
        'cancel_reason_id',
        'cancel_note',
    ];

    public function statusHistories()
    {
        return $this->hasMany(DeliveryStatusHistory::class);
    }

    public function statuses()
    {
        return $this->hasMany(DeliveryStatusHistory::class, 'delivery_id')->orderBy('created_at', 'desc');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id');
    }

    public function fromWarehouse()
    {
        return $this->belongsTo(Warehouse::class, 'from_warehouse_id');
    }

    public function toWarehouse()
    {
        return $this->belongsTo(Warehouse::class, 'to_warehouse_id');
    }

    public function zonePrice()
    {
        return $this->belongsTo(ZonePrice::class);
    }

    public function pickupBy()
    {
        return $this->belongsTo(User::class, 'pickup_by');
    }

    public function deliveryBy()
    {
        return $this->belongsTo(User::class, 'delivery_by');
    }

    public function truckBy()
    {
        return $this->belongsTo(User::class, 'truck_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function payments()
    {
        return $this->hasMany(PaymentDelivery::class);
    }

    public function driverPayment()
    {
        return $this->hasOne(DriverPayment::class, 'delivery_id');
    }

    public function driverPayments()  // note plural
    {
        return $this->hasMany(DriverPayment::class, 'delivery_id');
    }

    public static function getLastCodeNumber()
    {
        $lastCode = self::where('code', 'like', 'T%')
            ->orderBy('id', 'desc')
            ->value('code');

        if ($lastCode) {
            return intval(substr($lastCode, 1));
        }

        return 0;
    }

    public function cancelReason()
    {
        return $this->belongsTo(CancelReason::class);
    }
}
