<?php

namespace App\Models;

class DeliveryPayment extends BaseLoggableModel
{
    protected $fillable = [
        'delivery_id',
        'payment_to',
        'amount',
        'currency',
        'payment_method',
        'note',
        'created_by',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function delivery()
    {
        return $this->belongsTo(Delivery::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
