<?php

namespace App\Models;

class SummaryDriverPayment extends BaseLoggableModel
{
    protected $table = 'summary_driver_payment';

    protected $fillable = [
        'invoice_number',
        'exchange_rate',
        'total_amount_usd',
        'total_amount_khr',
        'payment_date',
        'driver_id',
        'status',
        'note',
        'created_by',
        'updated_by',
        'completed',
        'assigned',
        'canceled',
        'driver_collect_usd',
        'driver_collect_khr',
    ];

    public function driver()
    {
        return $this->belongsTo(User::class, 'driver_id');

    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function confirmPayments()
    {
        return $this->hasMany(ConfirmDriverPayment::class, 'summary_id');
    }

    public function payments()
    {
        return $this->hasMany(DriverPayment::class, 'summary_id');
    }

    public function deliveries()
    {
        return $this->hasMany(Delivery::class, 'summary_id');
    }

    public function driverPayments()
    {
        return $this->hasMany(DriverPayment::class, 'summary_id');
    }
}
