<?php

use App\Models\ZonePrice;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('delivery', function (Blueprint $table) {
            $table->id();
            $table->foreignId('from_warehouse_id')->nullable()->constrained('warehouses')->onDelete('set null');
            $table->foreignId('to_warehouse_id')->nullable()->constrained('warehouses')->onDelete('set null');
            $table->foreignId('truck_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('shipping_method')->default('land'); // sea,air
            $table->decimal('kg', 10, 2)->default(0);
            $table->bigInteger('pcs')->default(0);
            $table->decimal('cbm', 10, 2)->default(0);
            $table->text('photo')->nullable();
            $table->string('tracking_number')->nullable()->unique();
            $table->string('local_tracking')->nullable()->unique();
            $table->string('code')->unique();
            $table->foreignId('branch_id')->constrained()->onDelete('cascade');
            $table->foreignId('customer_id')->nullable()->constrained('customers')->onDelete('cascade');
            $table->foreignIdFor(ZonePrice::class)->nullable()->constrained();
            $table->string('receiver_address')->nullable();
            $table->string('receiver_phone')->nullable();
            $table->foreignId('pickup_by')->nullable()->constrained('users')->onDelete('set null');
            $table->dateTime('pickup_at')->nullable();
            $table->foreignId('delivery_by')->nullable()->constrained('users')->onDelete('set null');
            $table->dateTime('assigned_at')->nullable();
            $table->decimal('delivery_price', 10, 2)->default(0);
            $table->decimal('amount_usd', 10, 2)->default(0);
            $table->decimal('amount_khr', 10, 2)->default(0);
            $table->string('status')->default('in_stock'); // booking, in_stock, assigned, delivered, completed, returned, cancelled
            $table->string('type_of_delivery')->default('Normal'); // Normal, Express
            $table->string('type_of_cod')->default('Yes'); // Yes, No
            $table->decimal('any_extra_fee', 10, 2)->default(0);
            $table->string('who_pay_fee')->default('Shop'); // Driver,Company,Shop

            $table->string('note')->nullable();
            $table->dateTime('completed_at')->nullable();
            $table->boolean('is_collected')->default(false);
            $table->foreignId('collected_by')->nullable()->constrained('users')->onDelete('set null');

            $table->foreignId('created_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('updated_by')->nullable()->constrained('users')->onDelete('set null');
            $table->foreignId('deleted_by')->nullable()->constrained('users')->onDelete('set null');
            $table->boolean('is_active')->default(true);

            $table->boolean('is_deleted')->default(false);
            $table->string('deleted_reason')->nullable();
            $table->boolean('is_paid')->default(false);

            $table->foreignId('cancel_reason_id')->nullable()->constrained('cancel_reasons')->nullOnDelete();
            $table->text('cancel_note')->nullable();
            $table->dateTime('canceled_at')->nullable();
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('delivery');
    }
};
