<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionSeeder extends Seeder
{
    public function run(): void
    {
        // Define all modules and actions
        $modules = [
            'dashboard',
            'driver-summary-dashboard',
            'customer-summary-dashboard',
            'users',
            'roles',
            'branch',
            'cancel-reason',
            'zone-types',
            'zone-price',
            'assign-zones',
            'global-exchange-rate',
            'customers',
            'delivery',
            'driver-payment',
            'customer-payment',
            'reports',
            'setting',
        ];

        $defaultActions = ['view', 'create', 'edit', 'delete'];
        $deliveryActions = ['assign', 'assign-create', 'transfer', 'transfer-create', 'remove', 'remove-create', 'process-cancel', 'process-payment', 'print-invoice'];
        $reportActions = ['export-pdf', 'export-excel'];
        $driverPaymentActions = ['adjust', 'reverse'];
        $customerPaymentActions = ['download', 'adjust', 'transfer'];

        $permissions = [];

        foreach ($modules as $module) {
            $actions = $defaultActions;

            // Only add extra actions for the delivery module
            if ($module === 'delivery') {
                $actions = array_merge($actions, $deliveryActions);
            }

            if ($module === 'reports') {
                $actions = array_merge($actions, $reportActions);
            }

            if ($module === 'driver-payment') {
                $actions = array_merge($actions, $driverPaymentActions);
            }

            if ($module === 'customer-payment') {
                $actions = array_merge($actions, $customerPaymentActions);
            }

            foreach ($actions as $action) {
                $permissions[] = "{$module}.{$action}";
            }
        }

        // Create permissions
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Define roles with permissions
        $rolesWithPermissions = [
            'admin' => $permissions, // admin gets all permissions
            'staff' => [
                'dashboard.view',
                'users.view',
                'users.edit',
                'roles.view',
                'roles.edit',
                'branch.view',
                'branch.edit',
                'cancel-reason.view',
                'zone-types.view',
                'zone-price.view',
                'assign-zones.view',
                'global-exchange-rate.view',
                'customers.view',
                'delivery.view',
                'delivery.create',
                'delivery.edit',
                'delivery.delete',
                'driver-payment.view',
                'customer-payment.view',
                'reports.view',
                'reports.export-pdf',
                'reports.export-excel',
                'setting.view',
            ],
            'customer' => [
                'dashboard.view',
                'customers.view',
                'delivery.view',
                'reports.view',
            ],
            'driver' => [
                'dashboard.view',
                'delivery.view',
                'driver-payment.view',
                'delivery.process-payment',
                'delivery.process-cancel',
            ],
        ];

        // Create roles and assign permissions
        foreach ($rolesWithPermissions as $roleName => $perms) {
            $role = Role::firstOrCreate(['name' => $roleName]);
            $role->syncPermissions($perms);
        }

        // Create admin user and assign role
        $adminUser = User::firstOrCreate([
            'email' => 'info@softcreative.biz',
        ], [
            'display_name' => 'Admin User',
            'name' => 'admin',
            'status' => 'active',
            'avatar' => 'https://example.com/avatar.png',
            'phone' => '093322910',
            'email_verified_at' => now(),
            'password' => Hash::make('password'),
            'default_branch_id' => 1,
        ]);

        $adminUser->assignRole('admin');
        $adminUser->branches()->sync([1]);
        // User::factory(100)->create();
    }
}
