<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class ZonePriceTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Example zone prices
        $zonePrices = [
            [
                'zone_type_id' => 1,
                'branch_id' => 1,
                'zone_name' => 'BKK',
                'status' => 'active',
                'price' => 1.00,
                'currency' => 'USD',
            ],
            [
                'zone_type_id' => 2,
                'branch_id' => 1,
                'zone_name' => 'Phnom Penh Tmey',
                'status' => 'active',
                'price' => 1.50,
                'currency' => 'USD',
            ],
            // Add more zone prices as needed
        ];

        foreach ($zonePrices as $zonePrice) {
            \App\Models\ZonePrice::create($zonePrice);
        }
    }
}
