
<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
           Order entry
        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="" enctype="multipart/form-data" class="space-y-4">
            @csrf

          <div class="grid grid-cols-1 gap-3 sm:grid-cols-4">

          <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100">Customers <span class="text-red-300 text-xs mt-1">*</span></span>
               <select     name="customer_id"
                x-model="$store.deliveryForm.selectedCustomerId"
                @change="$dispatch('customer-updated')"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: 'Search or select an customer...',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value="">Select an customers</option>
                 @foreach($customer as $customerOption)
                        <option value="{{ $customerOption->id }}"
                            {{ old('customer_id') == $customerOption->id ? 'selected' : '' }}>
                            {{ $customerOption->customer_name }} {{ $customerOption->phone }} ({{ $customerOption->type_of_customer}})
                        </option>
                    @endforeach
                </select>
              
                @error('customer_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            </label>
        </div>


           
        <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100">From Warehouse <span class="text-red-300 text-xs mt-1">*</span></span>
                <select name="from_warehouse"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: 'Search warehouse...',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value="">Select an from warehouse</option>
                 @foreach($warehouse as $id => $name)
                            <option value="{{ $id }}" {{ old('from_warehouse') == $id ? 'selected' : '' }}>
                                {{ $name }}
                            </option>
                        @endforeach
                </select>
                @error('from_warehouse') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            </label>
        </div>



        <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100">To Warehouse <span class="text-red-300 text-xs mt-1">*</span></span>
                <select name="to_warehouse"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: 'Search To warehouse...',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value="">Select an To warehouse</option>
                 @foreach($warehouse as $id => $name)
                            <option value="{{ $id }}" {{ old('to_warehouse') == $id ? 'selected' : '' }}>
                                {{ $name }}
                            </option>
                        @endforeach
                </select>
                @error('to_warehouse') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            </label>
        </div>

          
       
        </div>

            <!-- Batch Data Inquiry-->
        @if ($errors->any())
            <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>- {{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif


        <div x-data="bankTable()" x-init="init()" @customer-updated.window="watchCustomer()" class="mt-6">
            <h3 class="text-lg font-medium mb-2">Create Order</h3>
            <div class="w-full">
                <table class="is-hoverable w-full text-left data-table">
                    <thead class="w-full bg-slate-100 dark:bg-navy-600">
                        <tr>
                            <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">ImportBy</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">TrackingNum</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">KG?</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">CBM?</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">PCS?</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">TotalFee</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">UploadPhoto</th>
                            <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                                <button type="button" @click="addRow()"
                                    class="btn rounded-full bg-green-500 text-white hover:bg-green-600">
                                    Add Record
                                </button>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <template x-for="(row, index) in rows" :key="index">
                        <tr>
                            <!-- Zone Select -->
                            <td class="p-2">
                                <div x-data>
                                    <select :name="`items[${index}][shipping_method]`" x-model="row.shipping_method"
                                            x-init="$nextTick(() => new TomSelect($el, {
                                                create: false,
                                                sortField: {
                                                    field: 'text',
                                                    direction: 'asc'
                                                },
                                                placeholder: 'Search...',
                                                }))"
                                            class="w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                                            >
                                            <option value="">Select an shipping</option>
                                            @foreach ($shippingMethod as $method)
                                                <option value="{{ $method->value }}">
                                                    {{ $method->label() }}
                                                </option>
                                            @endforeach

                                        </select>
                                </div>
                                
                            </td>

                            <!-- Tracking -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][tracking_number]`" x-model="row.tracking_number"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="tracking number">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>

                            <!-- KG -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][kg]`" x-model="row.kg"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="How many kg?">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>

                             <!-- CBM -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][cbm]`" x-model="row.cbm"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="How many cbm?">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>

                            <!-- PCS -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][pcs]`" x-model="row.pcs"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="How many pcs?">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>


                            <!-- Fee -->
                            <td class="p-2">
                                <span class="relative flex">
                                <input type="text" :name="`items[${index}][amount_usd]`" x-model="row.amount_usd"
                                    class="form-input peer  w-[150px] rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Amount USD">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fas fa-money-bill"></i>
                                    </span>
                                </span>
                            </td>

                            <td class="p-2">
                                <div class="flex items-center gap-2">
                                    <!-- File input -->
                                    <input
                                        type="file"
                                        accept="image/*"
                                        :name="`items[${index}][photo]`"
                                        @change="previewImage($event, index)"
                                        class="block w-full text-xs text-slate-500
                                            file:mr-2 file:rounded-full file:border-0
                                            file:bg-primary file:px-3 file:py-1
                                            file:text-white hover:file:bg-primary-focus"
                                    >

                                    <!-- Image preview -->
                                    <template x-if="row.preview">
                                        <img
                                            :src="row.preview"
                                            class="h-10 w-10 rounded border object-cover"
                                            alt="Preview"
                                        >
                                    </template>
                                </div>
                            </td>


                            <!-- Remove Button -->
                            <td class="p-2 text-center">
                                <div @click="removeRow(index)" class="badge cursor-pointer p-2 space-x-2 bg-red-100 text-red-800 dark:bg-red-500 dark:text-white">
                                    <i class="fas fa-trash"></i>
                                    <span>Remove</span>
                                </div>
                            </td>
                        </tr>
                    </template>

                    </tbody>
                </table>
            </div>
           
        </div>
            <!-- Form Buttons -->
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="{{ route('customer.index') }}"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                    Cancel
                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2">
                   Save
                </button>
            </div>
        </form>
    </div>
</div>
<script>
    window.oldItems = @json(old('items', []));

    function bankTable() {
        return {
            rows: window.oldItems.length
                ? window.oldItems.map(item => ({
                    ...item,
                    preview: item.preview ?? null,
                }))
                : [
                    {
                        shipping_method: '',
                        tracking_number: '',
                        kg: '',
                        cbm: '',
                        pcs: '',
                        amount_usd: '',
                        preview: null,
                    }
                ],

            init() {},

            addRow() {
                this.rows.push({
                    shipping_method: '',
                    tracking_number: '',
                    kg: '',
                    cbm: '',
                    pcs: '',
                    amount_usd: '',
                    preview: null,
                });
            },

            removeRow(index) {
                this.rows.splice(index, 1);
            },

            previewImage(event, index) {
                const file = event.target.files[0];
                if (!file) return;

                // Validate image
                if (!file.type.startsWith('image/')) {
                    alert('Please upload an image file');
                    event.target.value = '';
                    return;
                }

                // Create preview
                const reader = new FileReader();
                reader.onload = e => {
                    this.rows[index].preview = e.target.result;
                };
                reader.readAsDataURL(file);
            }
        };
    }
</script>
<!-- 
<script>



    window.oldItems = @json(old('items', []));

    document.addEventListener('alpine:init', () => {
        Alpine.store('deliveryForm', {
            selectedCustomerId: @json(old("customer_id")),
        });
    });

    function bankTable() {
        return {
            rows: window.oldItems.length
                ? window.oldItems
                : [
                    {
                        shipping_method: '',
                        tracking_number: '',
                        kg: '',
                        cbm: '',
                        pcs: '',
                        amount_usd: '',
                    }
                ],

            init() {
                // nothing special for now
            },

            addRow() {
                this.rows.push({
                    shipping_method: '',
                    tracking_number: '',
                    kg: '',
                    cbm: '',
                    pcs: '',
                    amount_usd: '',
                });
            },

            removeRow(index) {
                this.rows.splice(index, 1);
            },

            watchCustomer() {
                // If later you want VIP / MOU pricing logic, add here
                console.log('Customer changed:', Alpine.store('deliveryForm').selectedCustomerId);
            }
        };
    }
</script> -->


