<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice Pickup</title>

<link href="https://fonts.googleapis.com/css2?family=Battambang&display=swap" rel="stylesheet">

<style>
    * {
        box-sizing: border-box;
    }
    body {
        margin: 0;
        background: #eee;
        font-family: Arial, Battambang, sans-serif;
        font-size: 11px;
    }
    .page {
        width: 240mm;
        background: #fff;
        margin: auto;
        padding: 5mm;
        border: 1px solid #000;
    }

    /* HEADER */
    .header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 4px;
    }
    .logo {
        font-size: 22px;
        font-weight: bold;
        color: #18a999;
    }
    .logo span {
        color: #ff6a00;
    }
    .header-right {
        text-align: right;
        font-size: 9px;
    }

    /* MAIN GRID */
    .main {
        display: grid;
        grid-template-columns: 70% 30%;
        gap: 2px;
    }

    /* TABLE BASE */
    table {
        width: 100%;
        border-collapse: collapse;
    }
    td {
        border: 1px solid #000;
        padding: 3px;
        vertical-align: top;
    }

    /* SECTION HEADER */
    .section {
        background: #ff6a00;
        color: #fff;
        font-weight: bold;
        font-size: 10px;
    }

    /* LABELS */
    .label {
        font-size: 9px;
        font-weight: bold;
        color: #1CBC97;
    }
    .value {
        min-height: 12px;
    }

    /* RIGHT PANEL */
    .right-title {
        background: #cceff2;
        font-weight: bold;
        text-align: center;
    }

    /* CHECKBOX */
    .cb {
        display: inline-block;
        width: 10px;
        height: 10px;
        border: 1px solid #000;
        margin-right: 4px;
    }

    /* BARCODE */
    .barcode {
        text-align: center;
        padding: 4px;
    }

    /* FOOTER */
    .footer {
        font-size: 12px;
        margin-top: 2px;
    }
    .header-right .float-left{
            margin-right: 106px;
        float: left;
        font-size: 18px;
    }
    /* @media print {
    body {
        background: #fff;
    }

    .page {
        page-break-after: always;
        border: none;
        margin: 0;
        width: 100%;
    }

    table, tr, td {
        page-break-inside: avoid;
    }
} */

</style>
</head>

<body>
    <?php for($i=0;$i<=1;$i++){ ?>
<div class="page">
    <div class="header">
        <div class="logo">
            @if($currentBranch && $currentBranch->logo)
                <img class="size-11 transition-transform duration-500 ease-in-out hover:rotate-[360deg]"
                    src="{{ asset('storage/'. $currentBranch->logo) }}" alt="Branch Logo" />
            @else
                <img class="size-11 transition-transform duration-500 ease-in-out hover:rotate-[360deg]"
                    src="{{ asset('images/app-logo.svg') }}" alt="Default Logo" />
            @endif
        </div>
        <div class="header-right">
            <div class="float-left" style="float: left;">
            {{$currentBranch->url}}<br>
            TEL: {{ $currentBranch->phone }}
            </div>
            <div class="float-right" style="float: right;">
            @php
                $tracking = route('tracking.search');
                $qrCode = base64_encode(
                    QrCode::format('png')->size(200)->generate($tracking.'?code='.$delivery->code)
                );
            @endphp
            <img src="data:image/png;base64,{{ $qrCode }}" alt="QR Code" style="display: block; margin: auto; width: 80px;">
            </div>
        </div>
    </div>

    <div class="main">

        <!-- LEFT SIDE -->
        <table>
                
            <tr>
                <td colspan="2" class="section" width="50%">FROM</td>
                <td colspan="2" class="section" width="50%">TO</td>
            </tr>
            <tr>
                <td>
                    <div class="label">SHIPPER'S A/C NO.</div>
                    85211006<br><br>
                </td>
                <td><div class="label">SHIPPER'S REFERENCE</div></td>
                <td colspan="2">
                    <div class="label">Consignee’s Name</div>
                        {{$delivery->toWarehouse->name}}
                    </div>
                </td>
            </tr>

            <tr>
                <td colspan="2">
                    <div class="label">SHIPPER'S NAME</div>
                    {{$delivery->fromWarehouse->name}} <br><br>
                </td>
                <td colspan="2" rowspan="2">
                    <div class="label">ADDRESS</div>
                        <strong>  {{$delivery->toWarehouse->address}} </strong>
            <br/> <br/><br/><br/>
            <strong>VAT/EORI：
            </strong>
                    </div>
                </td>
            </tr>

            <tr>
                <td colspan="2">
                    <div class="label">ADDRESS</div>
                 <strong>  {{$delivery->fromWarehouse->address}} </strong><br><br>
                </td>
            </tr>

            <tr>
                <td>
                    <div class="label">CONTACT</div>
                   <strong> {{$delivery->fromWarehouse->contact_name}} </strong> <br><br>
                </td>
                <td><div class="label">TEL.</div>
                  <strong>  {{$delivery->fromWarehouse->contact_phone}} </strong>
                </td>
                <td>
                    <div class="label">CITY</div>
                   <strong> {{$delivery->toWarehouse->city}}  </strong><br><br>
                </td>
                <td><div class="label">ZIP/POSTAL</div>
                   <strong> {{$delivery->toWarehouse->postal}} </strong>
                </td>
            </tr>

            <tr>
                <td>
                    <div class="label">TOTAL NO. OF PACKAGES</div>
                    <strong>{{$delivery->pcs}}</strong> <br><br>
                </td>
                <td><div class="label">ACTUAL WEIGHT IN KG</div>
                    <strong>{{$delivery->kg}}</strong>  KG
                </td>
                <td>
                    <div class="label">CONTACT</div>
                   {{$delivery->toWarehouse->contact_name}}<br><br>
                </td>
                <td><div class="label">TEL.</div>
                    {{$delivery->toWarehouse->contact_phone}}
                </td>
            </tr>


            <tr>
                <td>
                    <div class="label">SUBMIT DATE</div>
                    <strong>{{$delivery->created_at}} </strong> 
                </td>
                <td>
                    <div class="label">CHARGEABLE WEIGHT</div>
                    <br/>
                </td>
                        
            <td>
                    <div class="label">RECEIVED BY </div>
                    <br/> 
                </td>
                <td>
                    <div class="label">DATE &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; / &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; /</div>
                    <br/>
                </td>
            </tr>


            <tr>
                <td colspan="2" rowspan="2">
                    <div class="label"><br/>
                    Shipper declares that the goods carried under this consignment contain
            no DANGEROUS GOODS, as described under the IATA dangerous
            goods regulations.
                    </div>
                </td>
                        
            <td>
                    <div class="label">SIGNATURE </div>
                    <br/>
                </td>
                <td>
                    <div class="label">TIME &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; :</div>
                    <br/>
                </td>
            </tr>

            <tr>    
            <td>
                    <div class="label">PICKED UP BY  </div>
                    <br/> 
                </td>
                <td>
                    <div class="label">DATE &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; / &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; /</div>
                    <br/>
                </td>
            </tr>


            <tr>
            <td>
                    <div class="label">SHIPPER'S SIGNATURE  </div>
                    <br/> 
                </td>
                <td>
                    <div class="label">DATE &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; / &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; /</div>
                    <br/>
                </td>
                        
            <td>
                    <div class="label">SIGNATURE  </div>
                    <br/>
                </td>
                <td>
                    <div class="label">TIME &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp; :</div>
                    <br/>
                </td>
            </tr>



            <tr>
                <td colspan="2">
                    <div class="label">Description of Goods</div>
                    <strong>Garment accessory</strong><br/>
                </td>
                <td colspan="2" class="barcode">
                    <img src="data:image/png;base64,{{ $barcode1D }}" alt="Barcode 1D" height="40">
                    <br>
                    <strong>{{$delivery->local_tracking}}</strong><br>
                  <div class="label">  SHIPMENT AIR WAYBILL (Non-negotiable)</div>
                </td>
            </tr>

        </table>

        <!-- RIGHT SIDE -->
        <table>
            <tr>
                <td class="right-title">AIRPORT OF DEPARTURE <br/><br/><br/><br/><br/></td>
                <td class="right-title">AIRPORT OF DESTINATION <br/><br/><br/><br/><br/></td>
            </tr>
            <tr>
                <td>
                    <div class="label">DOCUMENT <span class="cb" style="float: right;"></span></div>
                </td>
                <td>
                    <div class="label">NON-DOCUMENT <span class="cb" style="float: right;"></span> </div>
                </td>
            </tr>
            <tr>
                <td> <br/> 
                    <div class="label">CARGO INSURANCE <span class="cb" style="float: right;"></span></div>
                </td>
                <td>
                    <div class="label">ISURED VALUE <hr/> DECLARED VALUE :</div> <strong>USD {{$delivery->amount_usd}} </strong>
                </td>
            </tr>
            <tr>
                <td> <br/>
                    <div class="label">FREIGHT PAYMENT<span class="cb" style="float: right;"></span></div>
                </td>
                <td>
                    <div class="label">PREPAID <hr/> COLLECT</div>
                </td>
            </tr>

            <tr>
                <td>
                    <div class="label">SERIVCE</div>
                </td>
                <td>
                    <div class="label"><strong>(FREIGHT COLLECT)</strong></div>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <div class="label">SPECIAL HANDLING INSTRUCTIONS</div>
                    <strong>DN#{{$delivery->code}}</strong>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <div class="label">TRANSIT No:<br/><br/></div>
                    <strong>

                    </strong>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <div class="label">REFERENCE NO:<br/><br/></div>
                    <strong>

                    </strong>
                </td>
            </tr>
            <tr>
                <td>
                    <div class="label">CHARGEABLE WEIGHT IN KG<br/><br/></div>
                </td>
                <td>
                    <div class="label">CURRENCY</div>
                </td>
            </tr>
            <tr>
                <td>
                    <div class="label">SURCHARGES<br/><br/></div>
                </td>
                <td>
                    <div class="label">CURRENCY</div>
                </td>
            </tr>
            <tr>
                <td style="border: 0px; text-align:right">
                    <div class="label">TOTAL<br/><br/></div>
                </td>
                <td>
                    <div class="label">CURRENCY</div>
                </td>
            </tr>
        </table>

            
    <table style="width: 100%;">
        <tr>
            <td class="footer" style="border: 0px;">
                <div class="label">
                The carrier received the above goods in apparent good order and condition unless otherwise specified.
                </div>
            </td>
        </tr>
    </table>

    </div>
</div>

<?php } ?>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        window.print();
        window.onafterprint = function () {
            window.location.href = "{{ route('booking.index') }}";
        };
    });
</script>


</body>
</html>
