<x-app-layout title="driver payment summary" is-header-blur="false" is-sidebar-open="true" header-sticky="false" has-min-sidebar="false">


     <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                Driver payment summary
            </h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a
                        class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent"
                        href="#"
                    >List</a>
                    <svg
                        x-ignore
                        xmlns="http://www.w3.org/2000/svg"
                        class="size-4"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                    >
                        <path
                            stroke-linecap="round"
                            stroke-linejoin="round"
                            stroke-width="2"
                            d="M9 5l7 7-7 7"
                        />
                    </svg>
                </li>
                <li>All</li>
            </ul>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
       
          <div>
            <div class="card p-2 mt-3">
              <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left data-table">
                  <thead>
                    <tr>
                      <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Invoice<sup>No</sup></th>
                  <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Driver Name
                      </th>
                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                      Customers
                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Total Amount
                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        Total Amount
                      </th>
                     
                      <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                        CollectedBy
                      </th>
                    </tr>
                  </thead>
                  <tbody class="gridjs-tbody">
                   
                  </tbody>
                </table>
              </div>

          
            </div>
          </div>

        </div>


      </main>
</x-app-layout>


@stack('scripts')
<script>
$(function () {
    $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        autoWidth: false,
        scrollX: true,
        ajax: "{{ route('driver-payment.index') }}",
        columns: [
        { data: 'invoice', name: 'invoice' },
        { data: 'driver',   name: 'driver'},
        { data: 'total_package', name: 'total_package' },
        { data: 'driver_collect_from_customer', name: 'driver_collect_from_customer'},
        { data: 'collect_from_driver', name: 'collect_from_driver'},
        { data: 'action', name: 'action'},
    ],

        dom: "<'flex flex-col md:flex-row justify-between items-center mb-4'lf>tr<'flex flex-col md:flex-row justify-between items-center mt-4'ip>",
        language: {
            lengthMenu: "Show _MENU_ entries",
            search: "Search:",
            zeroRecords: "No matching records found",
             paginate: {
                 previous: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                    </svg>
                `,
                next: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                    </svg>
                `
            }
        },
         createdRow: function (row, data, dataIndex) {

            $(row).addClass(' hover:bg-slate-50 dark:hover:bg-navy-800');
            $('td', row).addClass('whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500');

        },
        drawCallback: function () {

            $('.dataTables_paginate .paginate_button')
            .addClass('flex mr-1 ml-1 h-8 min-w-[2rem] items-center justify-center bg-primary rounded-full bg-slate-150 px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90');

            $('.dataTables_paginate .paginate_button.previous, .dataTables_paginate .paginate_button.next')
                .addClass('flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90')
                .removeClass('px-3 min-w-[2rem]'); 

        }
    });

    $('.dataTables_filter input').addClass('form-input w-full rounded-full border border-slate-300 bg-transparent px-4 py-1 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_filter label').addClass('flex items-center space-x-2');
    $('.dataTables_length select').addClass('form-select rounded-full border border-slate-300 bg-white px-3 py-1 pr-6 text-xs-plus hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:text-navy-100 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_length label').addClass('flex items-center space-x-2');


});


</script>

