
<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
           Data Inquiry
        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="" enctype="multipart/form-data" class="space-y-4">
            @csrf

          <div class="grid grid-cols-1 gap-4 sm:grid-cols-3">

          <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100">Customers <span class="text-red-300 text-xs mt-1">*</span></span>
               <select     name="customer_id"
    x-model="$store.deliveryForm.selectedCustomerId"
    @change="$dispatch('customer-updated')"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: 'Search or select an customer...',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value="">Select an customers</option>
                 @foreach($customer as $customerOption)
                        <option value="{{ $customerOption->id }}"
                            {{ old('customer_id') == $customerOption->id ? 'selected' : '' }}>
                            {{ $customerOption->customer_name }} {{ $customerOption->phone }} ({{ $customerOption->type_of_customer}})
                        </option>
                    @endforeach
                </select>
              
                @error('customer_id') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            </label>
        </div>


           
        <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100">PickUp By <span class="text-red-300 text-xs mt-1">*</span></span>
                <select name="pickup_by"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: 'Search or select an pickup by...',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value="">Select an pick up by</option>
                 @foreach($driver as $id => $name)
                            <option value="{{ $id }}" {{ old('pickup_by') == $id ? 'selected' : '' }}>
                                {{ $name }}
                            </option>
                        @endforeach
                </select>
                @error('pickup_by') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            </label>
        </div>

          
        <div x-data>
            <label class="block">
            <span class="text-sm font-medium text-slate-700 dark:text-navy-100">Delviery By </span>
                <select name="delivery_by"
                x-init="$nextTick(() => new TomSelect($el, {
                    create: false,
                    sortField: {
                        field: 'text',
                        direction: 'asc'
                    },
                    placeholder: 'Search or select an delviery...',
                    }))"
                class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                >
                <option value="">Select an pick up by</option>
                 @foreach($driver as $id => $name)
                            <option value="{{ $id }}" {{ old('delivery_by') == $id ? 'selected' : '' }}>
                                {{ $name }}
                            </option>
                        @endforeach
                </select>
                @error('delivery_by') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
            </label>
        </div>

        </div>

            <!-- Batch Data Inquiry-->
        @if ($errors->any())
            <div class="mb-4 p-4 bg-red-100 text-red-700 rounded">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>- {{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif


        <div x-data="bankTable()" x-init="init()" @customer-updated.window="watchCustomer()" class="mt-6">
            <h3 class="text-lg font-medium mb-2">Create Batch Data Inquiry</h3>
            <div class="w-full">
                <table class="is-hoverable w-full text-left data-table">
                    <thead class="w-full bg-slate-100 dark:bg-navy-600">
                        <tr>
                            <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">Zone</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">Receiver Address</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">Delivery Price</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">Receiver Phone</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">Amount USD</th>
                            <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">Amount KHR</th>
                            <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                                <button type="button" @click="addRow()"
                                    class="btn rounded-full bg-green-500 text-white hover:bg-green-600">
                                    Add Record
                                </button>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <template x-for="(row, index) in rows" :key="index">
                        <tr>
                            <!-- Zone Select -->
                            <td class="p-2">
                                <div x-data>
                                    <select :name="`items[${index}][zone_id]`" x-model="row.zone_id" @change="updateDeliveryPrice(index)"
                                            x-init="$nextTick(() => new TomSelect($el, {
                                                create: false,
                                                sortField: {
                                                    field: 'text',
                                                    direction: 'asc'
                                                },
                                                placeholder: 'Search | Zone...',
                                                }))"
                                            class="w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                                            >
                                            <option value="">Select an zone</option>
                                            @foreach($zone as $bankOption)
                                                <option value="{{ $bankOption->id }}">
                                                    {{ $bankOption->zone_name }} - {{ $bankOption->price }} {{ $bankOption->currency }}
                                                </option>
                                            @endforeach
                                        </select>
                                </div>
                                
                            </td>

                            <!-- Receiver Address -->
                            <td class="p-2">
                                <span class="relative flex">
                                    <input type="text" :name="`items[${index}][receiver_address]`" x-model="row.receiver_address"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Receiver Address">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fa fa-address-card"></i>
                                    </span>
                                </span>
                            </td>

                            <!-- Delivery Price -->
                            <td class="p-2">
                                <span class="relative flex">
                                <input type="text" :name="`items[${index}][delivery_price]`" x-model="row.delivery_price"
                                    class="form-input  w-[150px] peer rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Delivery Price">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fas fa-dollar-sign"></i>
                                    </span>
                                </span>
                              
                            </td>

                            <!-- Receiver Phone -->
                            <td class="p-2">
                                <span class="relative flex">
                                <input type="text" :name="`items[${index}][receiver_phone]`" x-model="row.receiver_phone"
                                    class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Receiver Phone">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fas fa-phone"></i>
                                    </span>
                                </span>
                            </td>

                            <!-- Amount USD -->
                            <td class="p-2">
                                <span class="relative flex">
                                <input type="text" :name="`items[${index}][amount_usd]`" x-model="row.amount_usd"
                                    class="form-input peer  w-[150px] rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Amount USD">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fas fa-money-bill"></i>
                                    </span>
                                </span>
                            </td>

                            <!-- Amount KHR -->
                            <td class="p-2">
                                <span class="relative flex">
                                <input type="text" :name="`items[${index}][amount_khr]`" x-model="row.amount_khr"
                                    class="form-input peer w-[150px] rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                                    placeholder="Amount KHR">
                                    <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                                        <i class="fas fa-wallet"></i>
                                    </span>
                                </span>
                            </td>

                            <!-- Remove Button -->
                            <td class="p-2 text-center">
                                <div @click="removeRow(index)" class="badge cursor-pointer p-2 space-x-2 bg-red-100 text-red-800 dark:bg-red-500 dark:text-white">
                                    <i class="fas fa-trash"></i>
                                    <span>Remove</span>
                                </div>
                            </td>
                        </tr>
                    </template>

                    </tbody>
                </table>
            </div>
           
        </div>
            <!-- Form Buttons -->
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="{{ route('customer.index') }}"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                    Cancel
                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2">
                   Save
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    window.oldItems = @json(old('items', []));
    window.zonePrices = @json($zone);
    window.customers = @json($customer);


  document.addEventListener('alpine:init', () => {
        Alpine.store('deliveryForm', {
           selectedCustomerId: @json(old("customer_id")),
        });
    });


    function bankTable() {
    return {
        rows: window.oldItems?.length ? window.oldItems : [
            { zone_id: '', receiver_address: '', delivery_price: '', receiver_phone: '', amount_usd: '', amount_khr: '' }
        ],
        zonePrices: window.zonePrices,
        customers: window.customers,

        init() {
            // Force recalculate prices for all rows on initial load
            this.rows.forEach((_, index) => this.updateDeliveryPrice(index));
        },

        addRow() {
            this.rows.push({ zone_id: '', receiver_address: '', delivery_price: '', receiver_phone: '', amount_usd: '', amount_khr: '' });
        },

        removeRow(index) {
            this.rows.splice(index, 1);
        },

        get selectedCustomerId() {
            return Alpine.store('deliveryForm').selectedCustomerId;
        },

        getCurrentCustomer() {
            return this.customers.find(c => String(c.id) === String(this.selectedCustomerId));
        },

        isVip() {
            const customer = this.getCurrentCustomer();
            return customer && customer.type_of_customer?.toLowerCase() === 'vip';
        },

        updateDeliveryPrice(index) {
            const zone = this.zonePrices.find(z => z.id == this.rows[index].zone_id);
            const customer = this.getCurrentCustomer();

            this.rows[index].receiver_address = zone ? zone.zone_name : '';

            if (customer && customer.type_of_customer?.toLowerCase() === 'vip') {
                this.rows[index].delivery_price = customer.mou_price ?? '';
            } else {
                this.rows[index].delivery_price = zone?.price ?? '';
            }
        },

        watchCustomer() {
            this.rows.forEach((_, index) => this.updateDeliveryPrice(index));
        }
    };
}


</script>


