<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Delivery Invoice</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Battambang&display=swap');
        @import url('https://fonts.googleapis.com/css2?family=Noto+Sans+Khmer:wght@100..900&display=swap');

        body {
            font-family: 'Noto Sans Khmer', 'Battambang', sans-serif;
            margin: 0;
            padding: 0;
            width: 100%;
            font-size: 12px;
        }

        .print-area {
            width: 80mm;
            margin: auto;
            padding: 5px;
            background: white;
        }

        h2, h3, p {
            margin: 2px 0;
        }

        .text-center {
            text-align: center;
        }

        .text-left {
            text-align: left;
        }

        .text-right {
            text-align: right;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        .row {
            display: flex;
            flex-wrap: wrap;
        }

        .col-50 {
            width: 50%;
        }

        .col-100 {
            width: 100%;
        }

        .section-divider {
            width: 100%;
            border-top: 1px dashed #333;
            margin: 5px 0;
        }

        @media print {
            @page {
                size: 80mm auto;
                margin: 0;
            }

            body, html {
                width: 80mm;
                margin: 0;
                padding: 0;
            }

            .print-area {
                padding: 0;
            }
        }
    </style>
</head>
<body>
<div class="print-area">
    <div class="text-center">
        <img src="{{ asset('storage/'. $currentBranch->logo) }}" alt="Branch Logo" width="160">
        <p>{{ Carbon\Carbon::parse($delivery->created_at)->format('d/M/Y g:i:s A') }}</p>
        <h3>លេខបុង: {{ $delivery->code }}</h3>
    </div>

    <div class="section-divider"></div>

    <div class="text-left">
        <p><strong>លេខទូរស័ព្ទ (Receiver):</strong> {{ $delivery->receiver_phone }}</p>
        <p><strong>ទីតាំង:</strong> {{ $delivery->receiver_address }}</p>
        <p><strong>ចំណាំ:</strong> {{ $delivery->note ?? 'N/A' }}</p>
    </div>

    <div class="section-divider"></div>

    <div class="text-left">
        <p><strong>លេខទូរស័ព្ទ (Shop):</strong> {{ $delivery->customer?->phone }}</p>
        <p><strong>ឈ្មោះហាង:</strong> {{ $delivery->customer?->customer_name }}</p>
    </div>

    <div class="section-divider"></div>

    <table>
        <tr>
            <td><strong>តម្លៃ USD:</strong></td>
            <td class="text-right">${{ number_format($delivery->amount_usd, 2) }}</td>
        </tr>
        <tr>
            <td><strong>តម្លៃ KHR:</strong></td>
            <td class="text-right">៛{{ number_format($delivery->amount_khr, 0) }}</td>
        </tr>
    </table>

    <div class="text-center" style="margin-top: 10px;">
        <img src="data:image/png;base64,{{ $qrCodeBase64 }}" alt="QR Code" style="display: block; margin: auto; width: 80px;">
        <p style="font-size: 10px;">Scan for details</p>
    </div>

    <p class="text-center" style="margin-top: 10px; font-size: 10px;">សូមអរគុណ!</p>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        window.print();
        window.onafterprint = function () {
            window.location.href = "{{ route('delivery.index') }}";
        };
    });
</script>
</body>
</html>