<?php

use App\Http\Controllers\Api\Auth\LoginController;
use App\Http\Controllers\Api\DeliveryController;
use App\Http\Controllers\Api\DeliveryStatusController;
use Illuminate\Support\Facades\Route;

Route::post('/login', [LoginController::class, 'login']);

Route::middleware('auth:sanctum')->group(function () {
    Route::get('/delivery-listing', [DeliveryController::class, 'deliveryListing']);
    Route::post('/delivery-completed-payment', [DeliveryController::class, 'processCompletedPayment']);
    Route::post('/delivery-cancel-reason', [DeliveryController::class, 'processCancelReason']);
    Route::get('/delivery-status', [DeliveryStatusController::class, 'index']);
    Route::get('/delivery-payment-to', [DeliveryStatusController::class, 'paymentTo']);
    Route::get('/delivery-payment-payment-method', [DeliveryStatusController::class, 'paymentMethod']);

});
