<x-base-layout title="Login">
    <div class="fixed top-0 hidden p-6 lg:block lg:px-12">
        <a href="#" class="flex items-center space-x-2">
            @if($currentBranch && $currentBranch->logo)
                <img class="size-12" src="{{ asset('storage/'. $currentBranch->logo) }}" alt="logo" />
            @else
                <img class="size-12" src="{{ asset('images/app-logo.svg') }}" alt="logo" />
            @endif
            <p class="text-xl font-semibold uppercase text-slate-700 dark:text-navy-100">
                {{ config('app.name') }}
            </p>
        </a>

    </div>
    <div class="hidden w-full place-items-center lg:grid">
        <div class="w-full max-w-lg p-6">

           <div class="mt-8" x-data="trackingSearch()">
                <h3 class="text-center text-lg font-semibold text-slate-600 dark:text-navy-100 mb-4">
                    {{ __('messages.track_your_delivery') }}
                </h3>

                <div class="flex w-full max-w-md space-x-2 mb-4 border-b border-slate-200 dark:border-navy-500 pb-4">
                    <div class="relative flex w-full">
                        <input type="text" x-model="trackingCode"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-slate-100 px-4 py-2 pl-10 text-sm placeholder:text-slate-400 hover:border-primary focus:border-primary focus:ring-1 focus:ring-primary dark:border-navy-450 dark:bg-navy-700 dark:placeholder:text-navy-300 dark:hover:border-accent dark:focus:border-accent dark:focus:ring-accent"
                            placeholder="{{__('messages.enter_tracking_code')}}">
                        <span
                            class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3 text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fas fa-route"></i>
                        </span>
                    </div>

                    <button @click="search"
                        class="btn h-10 rounded-full bg-primary px-4 text-sm font-medium text-white hover:bg-primary-focus focus:outline-none focus:ring-2 focus:ring-primary dark:bg-accent dark:hover:bg-accent-focus dark:focus:ring-accent">
                        {{__('messages.search')}}
                    </button>
                </div>

                <!-- Error Message -->
                <template x-if="errorMessage">
                    <div class="mt-4 text-center text-error" x-text="errorMessage"></div>
                </template>

                <!-- Loading Spinner -->
                <template x-if="isLoading">
                    <div class="mt-4 text-center text-slate-500 dark:text-navy-300">Loading...</div>
                </template>

                <!-- Delivery Timeline -->
                <template x-if="statuses.length > 0">
                    <ol class="timeline max-w-xl mx-auto mt-2"> 
                        <h2 class="text-start text-md font-semibold text-slate-600 dark:text-navy-100 mt-6 mb-4">
                            {{__('messages.status_history')}}
                         </h2>
                        <template x-for="status in statuses" :key="status.id">
                            <li class="timeline-item">
                                <div :class="`timeline-item-point rounded-full ${getColor(status.status)}`">
                                    <template x-if="status.status.toLowerCase() === 'completed'">
                                        <span :class="`inline-flex h-full w-full animate-ping rounded-full ${getColor(status.status)} opacity-80`"></span>
                                    </template>
                                </div>
                                

                                <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                    <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                        <p class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0"
                                            x-text="`${status.status} | ${status.changed_by ?? 'System'}`">
                                        </p>
                                        <span class="text-xs text-slate-400 dark:text-navy-300" x-text="status.diff_for_humans"></span>
                                    </div>
                                    <p class="py-1">
                                        <div class="text-xs text-slate-400 dark:text-navy-300" x-text="status.changed_at"></div>
                                        <span x-text="status.note || 'Status updated.'"></span>
                                    </p>
                                </div>
                            </li>
                        </template>
                    </ol>
                </template>
                
            </div>

            
        </div>
    </div>

    <main class="flex w-full flex-col items-center bg-white dark:bg-navy-700 lg:max-w-md">
        <div class="flex w-full max-w-sm grow flex-col justify-center p-5">
          <!-- Language Switcher fixed at top-right -->
            <div class="fixed top-2 right-2 z-50" x-data="{ open: false }">
                <!-- Button -->
                <button
                    @click="open = !open"
                    class="flex items-center space-x-2 rounded-lg border border-slate-200
                        bg-white px-3 py-1.5 text-xs font-medium shadow-sm
                        hover:bg-slate-100 focus:outline-none
                        dark:border-navy-600 dark:bg-navy-800 dark:hover:bg-navy-700">

                    <!-- Current Language -->
                    <span class="flex items-center space-x-1">
                        @if(app()->getLocale() === 'km')
                            🇰🇭 <span>KM</span>
                        @elseif(app()->getLocale() === 'zh')
                            🇨🇳 <span>ZH</span>
                        @else
                            🇺🇸 <span>EN</span>
                        @endif
                    </span>

                    <!-- Arrow -->
                    <svg xmlns="http://www.w3.org/2000/svg"
                        class="size-4 text-slate-400 transition-transform"
                        :class="open && 'rotate-180'"
                        fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M19 9l-7 7-7-7" />
                    </svg>
                </button>

                <!-- Dropdown -->
                <div x-show="open"
                    x-transition
                    @click.outside="open = false"
                    class="absolute right-0 mt-2 w-36 overflow-hidden rounded-lg
                            bg-white shadow-lg dark:bg-navy-700">

                    <a href="{{ route('lang.switch','en') }}"
                    class="flex items-center space-x-2 px-4 py-2 text-sm
                    {{ app()->getLocale() === 'en'
                            ? 'bg-primary text-white'
                            : 'hover:bg-slate-100 dark:hover:bg-navy-600' }}">
                        🇺🇸 <span>English</span>
                    </a>

                    <a href="{{ route('lang.switch','km') }}"
                    class="flex items-center space-x-2 px-4 py-2 text-sm
                    {{ app()->getLocale() === 'km'
                            ? 'bg-primary text-white'
                            : 'hover:bg-slate-100 dark:hover:bg-navy-600' }}">
                        🇰🇭 <span>ខ្មែរ</span>
                    </a>
                </div>
            </div>


            <div class="flex items-center justify-center">
                <div class="text-center">
                    @if($currentBranch && $currentBranch->logo)
                        <img class="mx-auto size-16 lg:hidden"
                            src="{{ asset('storage/'. $currentBranch->logo) }}" alt="logo" />
                    @else
                        <img class="mx-auto size-16 lg:hidden"
                            src="{{ asset('images/app-logo.svg') }}" alt="logo" />
                    @endif

                    <div class="mt-4">
                        <h2 class="text-2xl font-semibold text-slate-600 dark:text-navy-100">
                            {{ __('messages.welcome') }}
                        </h2>
                        <p class="text-slate-400 dark:text-navy-300">
                            {{__('messages.please_sign_in')}}
                        </p>
                    </div>
                </div>
            </div>

            <form class="mt-16" action="{{ route('login') }}" method="post">
                @method('POST') @csrf
                <div>
                    <label class="relative flex">
                        <input
                            class="form-input peer w-full rounded-lg bg-slate-150 px-3 py-2 pl-9 ring-primary/50 placeholder:text-slate-400 hover:bg-slate-200 focus:ring-3 dark:bg-navy-900/90 dark:ring-accent/50 dark:placeholder:text-navy-300 dark:hover:bg-navy-900 dark:focus:bg-navy-900"
                            placeholder="{{__('messages.phone_numer_username')}}" type="text" name="login"
                            value="{{ old('login') }}" />
                         <span
                            class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                             <svg xmlns="http://www.w3.org/2000/svg" class="size-5 transition-colors duration-200"
                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M5.121 17.804A7 7 0 0112 15a7 7 0 016.879 2.804M15 10a3 3 0 11-6 0 3 3 0 016 0z" />
                            </svg>
                        </span>
                    </label>
                    @error('login')
                        <span class="text-tiny-plus text-error">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mt-4">
                    <label class="relative flex" x-data="{ show: false }">
                        <input
                            :type="show ? 'text' : 'password'"
                            class="form-input peer w-full rounded-lg bg-slate-150 px-3 py-2 pl-9 pr-10 ring-primary/50 placeholder:text-slate-400 hover:bg-slate-200 focus:ring-3 dark:bg-navy-900/90 dark:ring-accent/50 dark:placeholder:text-navy-300 dark:hover:bg-navy-900 dark:focus:bg-navy-900"
                            placeholder="{{__('messages.password')}}"
                            name="password"
                            value="{{ old('password') }}"
                        />

                        <!-- Key icon on the left -->
                        <span class="pointer-events-none absolute left-0 flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <svg xmlns="http://www.w3.org/2000/svg" class="size-5 transition-colors duration-200"
                                fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                            </svg>
                        </span>

                        <!-- Eye toggle icon on the right -->
                        <button type="button"
                            class="absolute right-0 flex h-full w-10 items-center justify-center text-slate-400 hover:text-primary dark:text-navy-300 dark:hover:text-accent"
                            @click="show = !show"
                            :aria-label="show ? 'Hide password' : 'Show password'">
                            <svg x-show="!show" xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M2.458 12C3.732 7.943 7.522 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.478 0-8.268-2.943-9.542-7z" />
                            </svg>
                            <svg x-show="show" xmlns="http://www.w3.org/2000/svg" class="size-5" fill="none"
                                viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                    d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.542-7a9.978 9.978 0 012.184-3.316M6.75 6.75A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.542 7a9.978 9.978 0 01-4.035 5.165M15 12a3 3 0 00-3-3m0 0a3 3 0 00-3 3m3-3l8.25 8.25M3 3l8.25 8.25" />
                            </svg>
                        </button>
                    </label>

                    @error('password')
                        <span class="text-tiny-plus text-error">{{ $message }}</span>
                    @enderror
                </div>

                <div class="mt-4 flex items-center justify-between space-x-2">
                    <label class="inline-flex items-center space-x-2">
                        <input
                            class="form-checkbox is-outline size-5 rounded-sm border-slate-400/70 bg-slate-100 before:bg-primary checked:border-primary hover:border-primary focus:border-primary dark:border-navy-500 dark:bg-navy-900 dark:before:bg-accent dark:checked:border-accent dark:hover:border-accent dark:focus:border-accent"
                            type="checkbox" />
                        <span class="line-clamp-1">{{__('messages.remember_me')}}</span>
                    </label>
                    <a href="#"
                        class="text-xs text-slate-400 transition-colors line-clamp-1 hover:text-slate-800 focus:text-slate-800 dark:text-navy-300 dark:hover:text-navy-100 dark:focus:text-navy-100">{{__('messages.forgot_password')}}
                        </a>
                </div>
                <button type="submit"
                    class="btn mt-10 h-10 w-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                    {{__('messages.sign_in')}}
                </button>
        
                <div class="my-7 flex items-center space-x-3">
                    <div class="h-px flex-1 bg-slate-200 dark:bg-navy-500"></div>
                    <p>{{ __('messages.or'  ) }}</p>
                    <div class="h-px flex-1 bg-slate-200 dark:bg-navy-500"></div>
                </div>
                
            </form>
        </div>
        <div class="my-5 flex justify-center text-xs text-slate-400 dark:text-navy-300">
            <a href="#">Privacy Notice</a>
            <div class="mx-3 my-1 w-px bg-slate-200 dark:bg-navy-500"></div>
            <a href="#">Term of service</a>
        </div>
    </main>
</x-base-layout>
<script>
function trackingSearch() {
    return {
        trackingCode: '',
        statuses: [],
        isLoading: false,
        errorMessage: '',

        search() {
            if (!this.trackingCode.trim()) {
                this.errorMessage = 'Please enter a tracking code.';
                return;
            }

            this.isLoading = true;
            this.errorMessage = '';
            this.statuses = [];

            fetch(`/api/search/tracking?code=${this.trackingCode}`)
                .then(response => {
                    if (!response.ok) throw new Error('Tracking code not found.');
                    return response.json();
                })
                .then(data => {
                    this.statuses = data.statuses;
                    if (this.statuses.length === 0) {
                        this.errorMessage = 'No status history found.';
                    }
                })
                .catch(error => {
                    this.errorMessage = error.message || 'Tracking code not found.';
                })
                .finally(() => {
                    this.isLoading = false;
                });
        },

        getColor(status) {
            switch (status.toLowerCase()) {
                case 'booking':
                    return 'bg-warning';
                case 'in_progress':
                    return 'bg-primary';
                case 'completed':
                    return 'bg-success';
                case 'cancelled':
                case 'returned':
                    return 'bg-error';
                default:
                    return 'bg-slate-300';
            }
        }
    }
}
</script>
