<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Delivery Invoice</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 0;
        }
        .invoice {
            width: 800px;
            margin: 0 auto;
            border: 1px solid #000;
            padding: 10px;
        }
        .header, .section {
            width: 100%;
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
        .header div, .section div {
            display: flex;
            flex-direction: column;
        }
        .barcode {
            text-align: center;
            margin: 10px 0;
        }
        .barcode img {
            width: 100%;
            max-height: 80px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 5px;
        }
        table, th, td {
            border: 1px solid #000;
        }
        th, td {
            padding: 5px;
            text-align: left;
        }
        .right {
            text-align: right;
        }
        .center {
            text-align: center;
        }
        .bold {
            font-weight: bold;
        }
        .no-border {
            border: none;
        }
    </style>
</head>
<body>
    <div class="invoice">
        <!-- Header -->
        <div class="header">
            <div>
                <div class="bold">{{ $delivery->code ?? 'PNHDC001' }} - {{ $delivery->tracking_number ?? '9491948' }}</div>
                <div>{{ $delivery->customer->customer_name ?? 'Pheaktra Tuy' }}</div>
            </div>
            <div class="right">
                <div>{{ now()->format('Y-m-d H:i:s') }}</div>
                <div>China - Cambodia</div>
            </div>
        </div>

        <!-- Barcode -->
        <div class="barcode">
            <img src="data:image/png;base64,{{ DNS1D::getBarcodePNG($delivery->tracking_number ?? '66127527491', 'C128') }}" alt="barcode" />
            <div class="center">{{ $delivery->tracking_number ?? '66127527491' }}</div>
        </div>

        <!-- Top section -->
        <div class="section">
            <div>
                <div>PC(s): <span class="bold">{{ $delivery->pcs ?? 1 }}</span></div>
                <div>COMMODITY: {{ $delivery->commodity ?? '灯具' }}</div>
            </div>
            <div>
                <div>CUSTOMER REF. N°</div>
                <div class="bold">{{ $delivery->customer->customer_name ?? 'Pheaktra Tuy' }}, {{ $delivery->customer->phone ?? '0966633554' }}</div>

                <div>SHIPPING ADDRESS</div>
                <div>{{ $delivery->customer->address ?? 'Cambodia, Phnom Penh, Dangkao' }}</div>
            </div>
        </div>

        <!-- Drop & weight info -->
        <table>
            <tr>
                <td>DROP BRANCH</td>
                <td>{{ $delivery->drop_branch ?? 'PNHDC003' }}</td>
                <td>ACTUAL WEIGHT</td>
                <td>{{ $delivery->kg ?? 26.9 }} kg</td>
                <td>DIMENSIONS (CM³)</td>
                <td>{{ $delivery->dimension ?? '74x63x30' }}</td>
            </tr>
            <tr>
                <td>CHARGEABLE CBM</td>
                <td>{{ $delivery->cbm ?? 0.14 }}</td>
                <td>FREIGHT FEE</td>
                <td>{{ $delivery->delivery_price ?? 23.8 }} USD</td>
                <td>OTHER FEE</td>
                <td>{{ $delivery->other_fee ?? 0 }} USD</td>
            </tr>
            <tr>
                <td colspan="4">TOTAL FEE</td>
                <td colspan="2">{{ $delivery->delivery_price ?? 23.8 }} USD</td>
            </tr>
        </table>

        <!-- Shipping & payment -->
        <table>
            <tr>
                <td>SHIPPING METHOD</td>
                <td>{{ $delivery->shipping_method ?? 'Land Import (Cargo & Consolidations Shipping)' }}</td>
            </tr>
            <tr>
                <td>PAYMENT METHOD</td>
                <td>{{ $delivery->payment_method ?? 'Collect' }}</td>
            </tr>
        </table>

        <!-- Remarks & signature -->
        <table>
            <tr>
                <td>REMARKS</td>
                <td>SIGNATURE</td>
            </tr>
        </table>

        <p style="text-align: center; margin-top: 10px; font-size: 10px;">
            If you use our service, it means you have agreed with our terms & conditions
        </p>
    </div>
</body>
</html>
