<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Shipping Label</title>
<style>
    body {
        font-family: Arial, sans-serif;
        margin: 20px;
    }
   .label {
        width: 80mm;        /* exact thermal width */
        height: 100mm;      /* optional fixed height */
        border: 1px solid #000;
        padding: 5mm;
        box-sizing: border-box;
        page-break-after: always; /* ensure each label prints separately */
    }

    .barcode, .barcode-small {
        text-align: left;
        margin: 5px 0;
    }
    .barcode img {
        width: 100%;
        height: 50px;
        object-fit: contain;
    }
    .info {
        font-size: 12px;
        margin: 5px 0;
    }
    .info strong {
        display: inline-block;
        width: 80px;
    }
    .dimensions {
        font-size: 19px;
        font-weight: bold;
        margin-top: 10px;
    }
    .footer {
        font-size: 10px;
        text-align: right;
        margin-top: 5px;
    }

    @media print {
    @page {
        size: 80mm 100mm;
        margin: 0;
    }
    body {
        margin: 0;
        padding: 0;
    }
    .label {
        page-break-after: always;
    }
}

</style>
</head>
<body>

@php
    $barcodeGenerator = new \Milon\Barcode\DNS1D();
@endphp
@foreach($deliveries as $k => $delivery)
@for ($i = 0; $i < $delivery->pcs; $i++)
<div class="label">
    <div class="info"><strong>Customer</strong></div>
    <div class="info"><strong>TID:</strong> {{$delivery->customer?->ref_code}}</div>

   
    <div class="barcode-small">
         <img src="data:image/png;base64,{{ $barcodeGenerator->getBarcodePNG($delivery->local_tracking, 'C128') }}" alt="barcode" />
        <div class="center">{{ $delivery->local_tracking }}</div>
    </div>


    <div class="info"><strong>Name:</strong> {{$delivery->customer?->customer_name}}</div>
    <div class="info"><strong>Address:</strong> {{$delivery->customer?->address}}</div>
    
    <hr/>

    <div class="dimensions">
        {{ $delivery->cm }} cm<br>
        {{$delivery->kg }} kg | {{ $delivery->cbm }} m³ | PC: {{$i + 1}}/{{$delivery->pcs}}
    </div>

    <div class="barcode-small">
        <img src="data:image/png;base64,{{ $barcodeGenerator->getBarcodePNG($delivery->tracking_number, 'C128') }}" alt="barcode" />
        <div class="center">{{ $delivery->tracking_number }}</div>
    </div>

    <div class="footer">
       {{$printBy}}<br>
         {{ now()->format('d M Y H:i') }}
    </div>
</div>
 @endfor
@endforeach

<script>
    document.addEventListener('DOMContentLoaded', function () {
        window.print();
        window.onafterprint = function () {
            window.location.href = "{{ route('data-inquiry.index') }}";
        };
    });
</script>
</body>
</html>
