   <x-app-layout title="Users" is-header-blur="false" is-sidebar-open="true"
        header-sticky="false" has-min-sidebar="false">

     <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">
                {{__('users.user')}}
            </h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                 <li class="flex items-center space-x-2">
                    <a
                        class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent"
                        href="#"
                    >{{ __('global.list') }}</a>
                    <svg
                        x-ignore
                        xmlns="http://www.w3.org/2000/svg"
                        class="size-4"
                        fill="none"
                        viewBox="0 0 24 24"
                        stroke="currentColor"
                    >
                        <path
                            stroke-linecap="round"
                            stroke-linejoin="round"
                            stroke-width="2"
                            d="M9 5l7 7-7 7"
                        />
                    </svg>
                </li>
                <li>{{ __('global.all') }}</li>
            </ul>

            <!-- Add New Button -->
            <div class="ml-auto">
                <a href="{{ route('users.create') }}"
                    class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">
                    {{ __('users.add_new') }}
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">

            <div class="card p-2 mt-3">
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 mb-4">

                    <div x-data>
                        <label class="block">
                            <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{ __('users.filter_branch') }} <span class="text-red-300 text-xs mt-1">*</span></span>
                            <select name="branches" id="branchesFilter"
                            x-init="$nextTick(() => new TomSelect($el, {
                                create: false,
                                sortField: {
                                    field: 'text',
                                    direction: 'asc'
                                },
                                placeholder: '{{__('global.search')}} ...',
                                }))"
                            class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                            >
                            <option value="">Select an branche</option>
                            @foreach($branches as $id => $name)
                                        <option value="{{ $name->id }}">
                                        {{ $name->code }}- {{ $name->name }} 
                                    </option>
                                @endforeach
                            </select>
                        </label>
                    </div>
                    

                    <div x-data>
                        <label class="block">
                            <span class="text-sm font-medium text-slate-700 dark:text-navy-100">{{__('role_permission.role')}}</span>
                            <select id="roleFilter"  name="role"
                            x-init="$nextTick(() => new TomSelect($el, {
                                create: false,
                                sortField: {
                                    field: 'text',
                                    direction: 'asc'
                                },
                                placeholder: '{{__('global.search')}} ...',
                                }))"
                            class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                            >
                            <option value="">Select an roles</option>
                            @foreach($roles as $r)
                                <option value="{{ $r->name }}">
                                    {{ $r->name }}
                                </option>
                            @endforeach
                            </select>
                        </label>
                    </div>
                
                </div>
                    
              <div class="gridjs-wrapper is-scrollbar-hidden min-w-full overflow-x-auto">
                <table class="is-hoverable w-full text-left data-table">
                  <thead>
                    <tr>
                      <th class="whitespace-nowrap rounded-tl-lg bg-slate-200 px-1 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-1">
                        {{__('global.no')}}
                     
                      <th class="whitespace-nowrap bg-slate-200 px-1 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-1">
                        {{__('users.avatar')}}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{ __('users.display_name') }}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('global.phoneNumber')}}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('role_permission.role')}}  
                      </th>
                       <th class="whitespace-nowrap bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('users.default_branch')}}
                      </th>
                      <th class="whitespace-nowrap bg-slate-200 px-2.5 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2.5">
                        {{__('global.status')}}
                      </th>
                      <th class="whitespace-nowrap rounded-tr-lg bg-slate-200 px-2 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-2">
                        {{__('global.action')}}</th>
                    </tr>
                  </thead>
                  <tbody class="gridjs-tbody">
                   
                  </tbody>
                </table>
              </div>

          
            </div>
          </div>


      </main>
</x-app-layout>


@stack('scripts')
<script>
$(function () {
    $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        autoWidth: false,
        ajax: {
            url: "{{ route('users.index') }}",
            data: function (d) {
                d.branch = $('#branchesFilter').val();
                d.role = $('#roleFilter').val();
            }
        },
        columns: [
             { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },

            { 
                data: 'avatar', 
                name: 'avatar',
                orderable: false,
                searchable: false,
                render: function(data, type, row) {
                    // if(data){
                    //     return `<img src="${data}" alt="Avatar" class="w-10 h-10 rounded-full object-cover">`;
                    // }
                    return `<div class="w-10 h-10 rounded-full bg-slate-300 dark:bg-navy-600"></div>`;
                }
            },
            { data: 'display_name', name: 'display_name' },
            { data: 'phone', name: 'phone' },
            { data: 'role', name: 'role' },
            { data: 'defaultBranch', name: 'defaultBranch' },
            {
            data: 'status', name: 'status',
                render: function(data) {
                    let colorClass = data === 'active' ? 'text-success' : 'text-error';
                    let bgClass = data === 'active' ? 'bg-primary' : 'bg-error';
                    return `
                    <div class="badge space-x-2.5 rounded-full ${bgClass}/10 ${colorClass} dark:${bgClass} dark:${bgClass}-light">
                        <div class="size-2 rounded-full bg-current"></div>
                        <span>${data}</span>
                    </div>
                    `;
                }
            },
            
            { data: 'action', name: 'action', orderable: false, searchable: false },
        ],
        dom: "<'flex flex-col md:flex-row justify-between items-center mb-4'lf>tr<'flex flex-col md:flex-row justify-between items-center mt-4'ip>",
        language: {
            lengthMenu: "{{__('global.show')}} _MENU_ {{__('global.entry')}}",
            search: "{{__('global.search')}}",
            zeroRecords: "{{__('global.search_not_found')}}",
            info: "{{ __('global.showing') }} _START_ {{__('global.To')}} _END_ {{__('global.Of')}} _TOTAL_ {{__('global.entry')}}",
            infoEmpty: "{{ __('global.showing') }} 0 {{ __('global.To') }} 0 {{ __('global.Of') }} 0 {{ __('global.entry') }}",
            infoFiltered: "({{ __('global.filter_from') }} _MAX_ {{ __('global.total_entries') }})",
             paginate: {
                 previous: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M15 19l-7-7 7-7"></path>
                    </svg>
                `,
                next: `
                    <svg xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 5l7 7-7 7"></path>
                    </svg>
                `
            }
        },
         createdRow: function (row, data, dataIndex) {

            $(row).addClass(' hover:bg-slate-50 dark:hover:bg-navy-800');
            $('td', row).addClass('whitespace-nowrap px-2 py-2 text-xs sm:px-2 border-y border-transparent border-b-slate-200 dark:border-b-navy-500');

        },
        drawCallback: function () {

            $('.dataTables_paginate .paginate_button')
            .addClass('flex mr-1 ml-1 h-8 min-w-[2rem] items-center justify-center bg-primary rounded-full bg-slate-150 px-3 leading-tight transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90');

            $('.dataTables_paginate .paginate_button.previous, .dataTables_paginate .paginate_button.next')
                .addClass('flex size-8 items-center justify-center rounded-full bg-slate-150 text-slate-500 transition-colors hover:bg-slate-300 focus:bg-slate-300 active:bg-slate-300/80 dark:bg-navy-500 dark:text-navy-200 dark:hover:bg-navy-450 dark:focus:bg-navy-450 dark:active:bg-navy-450/90')
                .removeClass('px-3 min-w-[2rem]'); 

        }
    });

    $('.dataTables_filter input').addClass('form-input w-full rounded-full border border-slate-300 bg-transparent px-4 py-1 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_filter label').addClass('flex items-center space-x-2');
    $('.dataTables_length select').addClass('form-select rounded-full border border-slate-300 bg-white px-3 py-1 pr-6 text-xs-plus hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:bg-navy-700 dark:text-navy-100 dark:hover:border-navy-400 dark:focus:border-accent');
    $('.dataTables_length label').addClass('flex items-center space-x-2');
});

$('#branchesFilter, #roleFilter').on('change', function () {
    $('.data-table').DataTable().ajax.reload();
});

</script>

