<!-- Generate User Login Modal -->
<div
    x-data="generateUserLoginModal()"
    x-cloak
    id="generateUserLoginModal"
    x-on:open-generate-login.window="open($event.detail.customerId)"
>
    <div
        class="fixed inset-0 z-100 flex items-center justify-center px-4 py-6 sm:px-5"
        x-show="showModal"
        @keydown.window.escape="close"
        x-transition
    >
        <!-- Overlay -->
        <div class="absolute inset-0 bg-slate-900/60" @click="close"></div>

        <!-- Modal Content -->
        <div class="relative w-full max-w-md rounded-lg bg-white dark:bg-navy-700">
            <!-- Header -->
            <div class="flex items-center justify-between border-b px-4 py-3">
                <h3 class="text-base font-medium">
                    <span x-show="step === 'confirm'">Confirm Generate User Login</span>
                    <span x-show="step === 'result'">User Login Generated</span>
                </h3>
                <button @click="close">✕</button>
            </div>

            <!-- BODY -->
            <div class="p-4">

                <!-- CONFIRM STEP -->
                <template x-if="step === 'confirm'">
                    <p class="text-sm text-center">
                        Are you sure you want to generate login for customer ID:
                        <span class="font-semibold" x-text="customerId"></span>
                    </p>
                </template>

                <!-- RESULT STEP -->
                <template x-if="step === 'result'">
                    <div class="space-y-3 text-sm">
                        <p>
                            <strong>Login URL:</strong><br>
                            <span x-text="url"></span>
                        </p>

                        <p class="flex items-center justify-between gap-2">
                            <span><strong>Username:</strong> <span x-text="credentials.login"></span></span>
                            <button @click="copy(credentials.login)" class="text-primary text-xs underline">
                                Copy
                            </button>
                        </p>

                        <p class="flex items-center justify-between gap-2">
                            <span>
                                <strong>Password:</strong>
                                <span x-show="!showPassword">••••••••</span>
                                <span x-show="showPassword" x-text="credentials.password"></span>
                            </span>

                            <div class="flex gap-2">
                                <button @click="showPassword = !showPassword"
                                    class="text-primary text-xs underline">
                                    Show
                                </button>
                                <button @click="copy(credentials.password)"
                                    class="text-primary text-xs underline">
                                    Copy
                                </button>
                            </div>
                        </p>

                        <p class="text-xs text-red-500">
                            ⚠ This password will not be shown again. Please copy it now.
                        </p>
                    </div>
                </template>

            </div>

            <!-- FOOTER -->
            <div class="flex justify-end gap-2 border-t px-4 py-3">

                <button
                    x-show="step === 'confirm'"
                    @click="close"
                    class="btn border border-red-400 bg-red-100 text-red-600"
                >
                    Cancel
                </button>

                <button
                    x-show="step === 'confirm'"
                    @click="submitGenerate"
                    :disabled="isLoading"
                    class="btn border border-primary/30 bg-primary/10 text-primary"
                >
                    <span x-show="!isLoading">Generate</span>
                    <span x-show="isLoading">Processing...</span>
                </button>

                <button
                    x-show="step === 'result'"
                    @click="close"
                    class="btn bg-primary text-white"
                >
                    Done
                </button>

            </div>
        </div>
    </div>
</div>
<script>
function generateUserLoginModal() {
    return {
        showModal: false,
        step: 'confirm', // confirm | result
        customerId: null,
        isLoading: false,
        showPassword: false,

        url: '{{ route('login') }}',
        credentials: {
            login: null,
            password: null,
        },

        open(customerId) {
            this.customerId = customerId
            this.step = 'confirm'
            this.showModal = true
            this.credentials = { login: null, password: null }
            this.showPassword = false
        },

        close() {
            this.showModal = false
        },

        submitGenerate() {
            this.isLoading = true

            fetch(`{{ route('customer.register-login', ':id') }}`
                .replace(':id', this.customerId), {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'X-Requested-With': 'XMLHttpRequest'
                }
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    this.credentials = data.data
                    this.step = 'result'

                    this.$notification({
                        text: data.message || 'User login generated successfully',
                        variant: 'success',
                        position: 'center-top'
                    })
                } else {
                    this.$notification({
                        text: data.message || 'Failed',
                        variant: 'error',
                        position: 'center-top'
                    })
                }
            })
            .catch(() => {
                this.$notification({
                    text: 'Server error',
                    variant: 'error',
                    position: 'center-top'
                })
            })
            .finally(() => {
                this.isLoading = false
            })
        },

        copy(text) {
            navigator.clipboard.writeText(text)
            this.$notification({
                text: 'Copied to clipboard',
                variant: 'dark',
                position: 'center-top'
            })
        }
    }
}
</script>
