
<div class="card">
    <div class="flex flex-col items-center space-y-0 border-b border-slate-200 p-2 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0">
        <h2 class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100">
            {{__('pickUp.create_book_pickup') }}
        </h2>
    </div>

    <div class="border border-slate-200 p-2 dark:border-navy-500 mt-3">
        <form method="POST" action="{{  route('book-pickup.store') }}" enctype="multipart/form-data" class="space-y-4">
            @csrf
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
           
                <!-- Customer Name -->
                <label class="block">
                    <span>{{__('customer.customer_name')}}</span>
                    <span class="mt-1.5">
                        <select name="customer_id"
                            x-init="$nextTick(() => new TomSelect($el, {
                                create: false,
                                sortField: {
                                    field: 'text',
                                    direction: 'asc'
                                },
                                placeholder: 'Search or select an pickup by...',
                                }))"
                            class="mt-1.5 w-full rounded-lg border-slate-300  dark:border-navy-450 dark:bg-navy-700"
                            >
                            <option value="">Select an pick up by</option>
                            @foreach($customer as $id => $name)
                                <option value="{{ $name->id }}" {{ old('customer_id') == $id ? 'selected' : '' }}>
                                    {{ $name->customer_name }}
                                </option>
                            @endforeach
                            </select>
                    </span>
                    @error('customer_name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                <!-- Total  -->
                <label class="block">
                    <span>{{__('pickUp.total_package')}}</span>
                    <span class="relative mt-1.5 flex">
                        <input name="total_package" value="{{ old('total_package') }}"
                            class="form-input peer w-full rounded-full border border-slate-300 bg-transparent px-3 py-2 pl-9 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                            placeholder="10" type="number" step="1" min="1"/>
                        <span class="pointer-events-none absolute flex h-full w-10 items-center justify-center text-slate-400 peer-focus:text-primary dark:text-navy-300 dark:peer-focus:text-accent">
                            <i class="fa fa-money-bill"></i>
                        </span>
                    </span>
                    @error('total_package') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

                <!-- Upload Images -->
                <label class="block" x-data="imageUploader()">
                    <span>{{__('pickUp.pickup_image')}}</span>

                    <!-- File Input -->
                    <input
                        type="file"
                        name="images[]"
                        multiple
                        accept="image/*"
                        @change="previewImages"
                        class="mt-1.5 w-full rounded border border-slate-300 bg-transparent px-3 py-2
                            dark:border-navy-450 dark:bg-navy-700"
                    >

                    <!-- Preview -->
                    <div class="mt-3 grid grid-cols-2 sm:grid-cols-4 gap-3" x-show="images.length">
                        <template x-for="(image, index) in images" :key="index">
                            <div class="relative border rounded-lg overflow-hidden">
                                <img :src="image" class="h-32 w-full object-cover">

                                <!-- Remove Button -->
                                <button type="button"
                                    @click="removeImage(index)"
                                    class="absolute top-1 right-1 bg-red-600 text-white rounded-full w-6 h-6 flex items-center justify-center text-xs">
                                    ✕
                                </button>
                            </div>
                        </template>
                    </div>

                    @error('images') 
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p> 
                    @enderror
                </label>


                 <label class="block">
                    <span>{{__('pickup.note')}}</span>
                    <textarea name="note"
                        class="form-input peer mt-1.5 w-full rounded border border-slate-300 bg-transparent px-3 py-2 placeholder:text-slate-400/70 hover:border-slate-400 focus:border-primary dark:border-navy-450 dark:hover:border-navy-400 dark:focus:border-accent"
                        placeholder="{{__('pickUp.enter_note')}}">{{ old('note') }}</textarea>
                    @error('note') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                </label>

            </div>

      
            <!-- Form Buttons -->
            <div class="flex justify-end mt-4 border-t border-slate-200 p-2 dark:border-navy-500 pt-4">
                <a href="{{ route('book-pickup.index') }}"
                    class="btn min-w-[7rem] rounded-full border border-slate-300 text-slate-700 hover:bg-slate-150 focus:bg-slate-150 dark:border-navy-450 dark:text-navy-100 dark:hover:bg-navy-500">
                    {{__('global.cancel')}}
                </a>
                <button type="submit"
                    class="btn min-w-[7rem] rounded-full bg-primary text-white hover:bg-primary-focus dark:bg-accent dark:hover:bg-accent-focus ml-2">
                   {{__('global.save')}}
                </button>
            </div>
        </form>
    </div>
</div>
<script>
function imageUploader() {
    return {
        images: [],
        files: [],

        previewImages(event) {
            const selectedFiles = Array.from(event.target.files);

            if (selectedFiles.length > 4) {
                alert('You can upload maximum 4 images only.');
                event.target.value = '';
                return;
            }

            this.images = [];
            this.files = selectedFiles;

            selectedFiles.forEach(file => {
                this.images.push(URL.createObjectURL(file));
            });
        },

        removeImage(index) {
            this.images.splice(index, 1);
            this.files.splice(index, 1);
        }
    }
}
</script>
