<x-app-layout title="Delivery View" is-header-blur="false" is-sidebar-open="true" header-sticky="false" has-min-sidebar="false">



    <main class="main-content w-full px-[var(--margin-x)] pb-8">
        <div class="flex items-center space-x-4 py-5 lg:py-6">
            <h2 class="text-xl font-medium text-slate-800 dark:text-navy-50 lg:text-2xl">Delivery</h2>
            <div class="hidden h-full py-1 sm:flex">
                <div class="h-full w-px bg-slate-300 dark:bg-navy-600"></div>
            </div>
            <ul class="hidden flex-wrap items-center space-x-2 sm:flex">
                <li class="flex items-center space-x-2">
                    <a class="text-primary transition-colors hover:text-primary-focus dark:text-accent-light dark:hover:text-accent" href="#">List</a>
                    <svg x-ignore xmlns="http://www.w3.org/2000/svg" class="size-4" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7" />
                    </svg>
                </li>
                <li>View</li>
            </ul>

            <!-- Back Button -->
            <div class="ml-auto">
                <a href="{{ route('delivery.index') }}" class="btn bg-primary text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90">Back</a>
            </div>
        </div>

        <div class="grid grid-cols-1 gap-4 sm:gap-5 lg:gap-6">
            <div>
                <div class=" p-2 mt-3">
                   
                <div class="grid grid-cols-12 gap-4 sm:gap-5 lg:gap-6">
                    <div class="col-span-12 lg:col-span-4">
                        <div class="card p-4 sm:p-5">
                           <div class="flex items-center space-x-4 mb-4 border-b border-slate-200 dark:border-navy-500 pb-4 w-full">
                                <div class="alert flex items-center justify-between rounded-lg bg-slate-100 p-3 dark:bg-navy-500 w-full">
                                    <p id="clipboardContent1" class="truncate">
                                        T000001
                                    </p>
                                    <button
                                        class="btn h-6 shrink-0 rounded bg-primary/20 px-2 text-xs text-white active:bg-white/25 dark:bg-primary-100 dark:text-navy-100 dark:hover:bg-navy-500 dark:active:bg-navy-700"
                                        @click="$clipboard({
                                            content:document.querySelector('#clipboardContent1').innerText,
                                            success:()=>$notification({text:'Code Copied',variant:'dark'}),
                                            error:()=>$notification({text:'Error',variant:'error'})
                                        })"
                                    >
                                        Copy
                                    </button>
                                </div>
                            </div>


                        <ol class="timeline max-w-sm">
                           
                                @php
                                    $color = match(strtolower('completed')) {
                                        'booking' => 'bg-warning',
                                        'in_progress' => 'bg-primary',
                                        'completed' => 'bg-success',
                                        'cancelled', 'returned' => 'bg-error',
                                        default => 'bg-slate-300',
                                    };
                                @endphp

                                <li class="timeline-item">
                                    <div class="timeline-item-point rounded-full {{ $color }}">
                                        @if(strtolower('completed') == 'completed')
                                            <span class="inline-flex h-full w-full animate-ping rounded-full {{ $color }} opacity-80"></span>
                                        @endif
                                    </div>

                                    <div class="timeline-item-content flex-1 pl-4 sm:pl-8">
                                        <div class="flex flex-col justify-between pb-2 sm:flex-row sm:pb-0">
                                            <p class="pb-2 font-medium leading-none text-slate-600 dark:text-navy-100 sm:pb-0">
                                                Completed | System
                                            </p>
                                            <span class="text-xs text-slate-400 dark:text-navy-300">
                                                {{ \Carbon\Carbon::now()->diffForHumans() }}
                                            </span>
                                        </div>
                                        <p class="py-1">
                                             <div class="text-xs text-slate-400 dark:text-navy-300">{{ \Carbon\Carbon::now() }}</div>
                                             {{'Status updated.' }}
                                        </p>
                                    </div>
                                </li>
                    
                        </ol>
                        </div>

                        <div class="card mt-4 p-2 sm:p-2">
                            <div>
                                <h2 class="mb-2"><strong>Allow Custoemr for login </strong></h2>

                                <div class="min-w-full">
                                    <table class="is-zebra w-full text-left">
                                    <thead>
                                        <tr>
                                        <th
                                            class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                                        >
                                            username
                                        </th>
                                        <th
                                            class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                                        >phone number
                                        </th>
                                        <th
                                            class="whitespace-nowrap rounded-r-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5"
                                        >
                                        Password
                                        </th>
                                        </tr>
                                    </thead>
                                    <tbody
                                        x-data="{
                                            showPassword: false,
                                            showModal: false,
                                            isRegistered: @js($isRegistered),
                                            url: @js(route('login')),
                                            userLogin: '{{$customer->userlogin?->name}}',
                                            password: '{{$customer->userlogin?->phone}}'
                                        }"
                                    >
                                        <!-- USER INFO ROW -->
                                        <tr x-show="isRegistered">
                                            <td class="whitespace-nowrap px-4 py-3 sm:px-5">{{$customer->userlogin?->name}}</td>
                                            <td class="whitespace-nowrap px-4 py-3 sm:px-5">{{$customer->userlogin?->phone}}</td>
                                            <td class="whitespace-nowrap rounded-r-lg px-4 py-3 sm:px-5">
                                                <div class="flex items-center gap-2">
                                                    <p class="truncate font-mono text-sm">
                                                        <span x-text="showPassword ? password : '••••••••'"></span>
                                                    </p>

                                                    <button
                                                        class="btn h-6 rounded bg-slate-500/20 px-2 text-xs text-white"
                                                        @click="showPassword = !showPassword"
                                                    >
                                                        <span x-text="showPassword ? 'Hide' : 'View'"></span>
                                                    </button>

                                                    <button
                                                        class="btn h-6 rounded bg-primary/20 px-2 text-xs text-white"
                                                        @click="$clipboard({
                                                            content: `- URL: ${url}
                                                            - UserLogin: ${userLogin}
                                                            - Password: ${password}`,
                                                            success: () => $notification({ text: 'Login info copied', variant: 'dark' })
                                                        })"
                                                    >
                                                        Copy
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>

                                        <!-- GENERATE LOGIN ROW -->
                                        <tr x-show="!isRegistered">
                                            <td colspan="3" class="px-4 py-3 text-center">
                                               
                                                <button
                                                    class="btn bg-success text-white"
                                                    @click="$dispatch('open-generate-login', { customerId: {{ $customer->id }} })"
                                                >
                                                    Generate Login
                                                </button>

                                            </td>
                                        </tr>

                                     

                                    </tbody>

                                    </table>
                                </div>
                               
                            </div>
                        </div>
                        
                    </div>
                    


                           



                    <div class="col-span-12 lg:col-span-8">
                        <div class="card">
                        <div
                            class="flex flex-col items-center space-y-4 border-b border-slate-200 p-4 dark:border-navy-500 sm:flex-row sm:justify-between sm:space-y-0 sm:px-5"
                        >
                            <h2
                            class="text-lg font-medium tracking-wide text-slate-700 dark:text-navy-100"
                            >
                               {{ 'Unknown Customer' }} | {{  'No Phone' }} | {{ 'No Address' }}
                            </h2>
                            <div class="flex justify-center space-x-2">
                            <button
                            onclick="printInvoice()"
                                class="btn min-w-[7rem] rounded-full bg-primary font-medium text-white hover:bg-primary-focus focus:bg-primary-focus active:bg-primary-focus/90 dark:bg-accent dark:hover:bg-accent-focus dark:focus:bg-accent-focus dark:active:bg-accent/90"
                            >
                                Print Receipt
                            </button>
                            </div>
                        </div>
                        <div class="p-4 sm:p-5">
                            <div class="flex flex-col">
                          
                               
                                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-4">
                                    <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                        <div class="flex justify-between space-x-1">
                                            <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                                ${{ 1 }}
                                            </p>
                                            <i class="fas fa-truck text-primary dark:text-accent"></i>
                                        </div>
                                        <p class="mt-1 text-xs-plus">Delivery Price</p>
                                    </div>

                                    
                                    <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                        <div class="flex justify-between space-x-1">
                                            <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                                $2
                                            </p>
                                            <i class="fas fa-dollar-sign text-primary dark:text-accent"></i>
                                        </div>
                                        <p class="mt-1 text-xs-plus">Amount USD</p>
                                    </div>

                                
                                    <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                        <div class="flex justify-between space-x-1">
                                            <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                                ៛22
                                            </p>
                                            <i class="fas fa-money-bill-wave text-primary dark:text-accent"></i>
                                        </div>
                                        <p class="mt-1 text-xs-plus">Amount KHR</p>
                                    </div>

                                     <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                        <div class="flex justify-between space-x-1">
                                            <p class="text-xl font-semibold text-slate-700 dark:text-navy-100">
                                              {{ 'Not Yet Assign' }}
                                            </p>
                                            <i class="fas fa-truck text-primary dark:text-accent"></i>
                                        </div>
                                        <p class="mt-1 text-xs-plus">Delivery By</p>
                                    </div>


                                </div>


                            </div>
                            <div class="my-7 h-px bg-slate-200 dark:bg-navy-500"></div>
                            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                           
                                <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                    <p class="text-sm text-slate-600 dark:text-navy-100">Receiver Phone</p>
                                    <p class="mt-1 text-base font-semibold text-slate-700 dark:text-navy-100">
                                        {{ 'No Phone' }}
                                    </p>
                                </div>

                                <div class="rounded-lg bg-slate-150 p-4 dark:bg-navy-500">
                                    <p class="text-sm text-slate-600 dark:text-navy-100">Receiver Address</p>
                                    <p class="mt-1 text-base font-semibold text-slate-700 dark:text-navy-100">
                                        {{ 'No Address' }}
                                    </p>
                                </div>
                            </div>

                            <table class="is-hoverable w-full text-left mt-5">
                                    <thead>
                                        <tr>
                                       <th class="whitespace-nowrap rounded-l-lg bg-slate-200 px-3 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Date
                                        </th>
                                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Paid To
                                        </th>
                                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Amount
                                        </th>
                                         <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Currency
                                        </th>
                                        <th class="whitespace-nowrap bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Payment Method
                                        </th>
                                        <th class="whitespace-nowrap rounded-r-lg bg-slate-200 px-4 py-3 font-semibold uppercase text-slate-800 dark:bg-navy-800 dark:text-navy-100 lg:px-5">
                                            Noted
                                        </th>
                                      
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                            <tr>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200 ">
                                                   {{ \Carbon\Carbon::now()->format('Y-m-d H:i:s') }}
                                                </td>
                                               <td class="px-4 py-2 text-slate-600 dark:text-navy-200 ">
                                                    {{ ucfirst('Driver') }}
                                                </td>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200 ">
                                                    {{ number_format(22, 2) }}
                                                </td>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200">
                                                    {{ 'USD' }}
                                                </td>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200">
                                                    {{ 'Credit Card' }}
                                                </td>
                                                <td class="px-4 py-2 text-slate-600 dark:text-navy-200">
                                                    {{ 'Payment for delivery service.' }}
                                                </td>
                                             
                                            </tr>
                                        
                                    </tbody>
                                </table>
                            


                         



                        </div>

                        </div>
                    </div>

                    </div>


                </div>
            </div>
        </div>
    </main>

   @include('pages.customers.modal')

</x-app-layout>

